/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.concurrent.Callable;
import org.apache.hadoop.shaded.org.assertj.core.description.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssertExtensions {
    private static final Logger LOG = LoggerFactory.getLogger(AssertExtensions.class);

    private AssertExtensions() {
    }

    public static Description dynamicDescription(Callable<String> eval) {
        return new DynamicDescription(eval);
    }

    private static final class DynamicDescription
    extends Description {
        private final Callable<String> eval;

        private DynamicDescription(Callable<String> eval) {
            this.eval = eval;
        }

        public String value() {
            try {
                return this.eval.call();
            }
            catch (Exception e) {
                LOG.warn("Failed to evaluate description: " + e);
                LOG.debug("Evaluation failure", (Throwable)e);
                return null;
            }
        }
    }
}

