/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestStandbyIsHot {
    protected static final Logger LOG = LoggerFactory.getLogger(TestStandbyIsHot.class);
    private static final String TEST_FILE_DATA = "hello highly available world";
    private static final String TEST_FILE = "/testStandbyIsHot";
    private static final Path TEST_FILE_PATH = new Path("/testStandbyIsHot");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testStandbyIsHot() throws Exception {
        Configuration conf = new Configuration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            Thread.sleep(1000L);
            System.err.println("==================================");
            DFSTestUtil.writeFile((FileSystem)fs, TEST_FILE_PATH, TEST_FILE_DATA);
            nn1.getRpcServer().rollEditLog();
            System.err.println("==================================");
            LOG.info("Waiting for block locations to appear on standby node");
            TestStandbyIsHot.waitForBlockLocations(cluster, nn2, TEST_FILE, 3);
            cluster.triggerHeartbeats();
            cluster.triggerBlockReports();
            LOG.info("Changing replication to 1");
            fs.setReplication(TEST_FILE_PATH, (short)1);
            BlockManagerTestUtil.computeAllPendingWork(nn1.getNamesystem().getBlockManager());
            TestStandbyIsHot.waitForBlockLocations(cluster, nn1, TEST_FILE, 1);
            nn1.getRpcServer().rollEditLog();
            LOG.info("Waiting for lowered replication to show up on standby");
            TestStandbyIsHot.waitForBlockLocations(cluster, nn2, TEST_FILE, 1);
            LOG.info("Changing replication to 3");
            fs.setReplication(TEST_FILE_PATH, (short)3);
            BlockManagerTestUtil.computeAllPendingWork(nn1.getNamesystem().getBlockManager());
            nn1.getRpcServer().rollEditLog();
            LOG.info("Waiting for higher replication to show up on standby");
            TestStandbyIsHot.waitForBlockLocations(cluster, nn2, TEST_FILE, 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDatanodeRestarts() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 1024);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        conf.setLong("dfs.namenode.accesstime.precision", 0L);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        try {
            NameNode nn0 = cluster.getNameNode(0);
            NameNode nn1 = cluster.getNameNode(1);
            cluster.transitionToActive(0);
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(0), TEST_FILE_PATH, 5120L, (short)1, 1L);
            HATestUtil.waitForStandbyToCatchUp(nn0, nn1);
            DataNode dn = cluster.getDataNodes().get(0);
            String dnName = dn.getDatanodeId().getXferAddr();
            MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
            BlockManagerTestUtil.noticeDeadDatanode(nn0, dnName);
            BlockManagerTestUtil.noticeDeadDatanode(nn1, dnName);
            BlockManagerTestUtil.updateState(nn0.getNamesystem().getBlockManager());
            BlockManagerTestUtil.updateState(nn1.getNamesystem().getBlockManager());
            Assert.assertEquals((long)5L, (long)nn0.getNamesystem().getUnderReplicatedBlocks());
            Assert.assertEquals((long)0L, (long)nn1.getNamesystem().getUnderReplicatedBlocks());
            LocatedBlocks locs = nn1.getRpcServer().getBlockLocations(TEST_FILE, 0L, 1L);
            Assert.assertEquals((String)"Standby should have registered that the block has no replicas", (long)0L, (long)locs.get(0).getLocations().length);
            cluster.restartDataNode(dnProps);
            cluster.waitActive(0);
            cluster.waitActive(1);
            cluster.waitFirstBRCompleted(0, 10000);
            cluster.waitFirstBRCompleted(1, 10000);
            BlockManagerTestUtil.updateState(nn0.getNamesystem().getBlockManager());
            BlockManagerTestUtil.updateState(nn1.getNamesystem().getBlockManager());
            Assert.assertEquals((long)0L, (long)nn0.getNamesystem().getUnderReplicatedBlocks());
            Assert.assertEquals((long)0L, (long)nn1.getNamesystem().getUnderReplicatedBlocks());
            locs = nn1.getRpcServer().getBlockLocations(TEST_FILE, 0L, 1L);
            Assert.assertEquals((String)"Standby should have registered that the block has replicas again", (long)1L, (long)locs.get(0).getLocations().length);
        }
        finally {
            cluster.shutdown();
        }
    }

    static void waitForBlockLocations(final MiniDFSCluster cluster, final NameNode nn, final String path, final int expectedReplicas) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    DatanodeInfoWithStorage[] dnis;
                    LocatedBlocks locs = NameNodeAdapter.getBlockLocations(nn, path, 0L, 1000L);
                    for (DatanodeInfoWithStorage dni : dnis = locs.getLastLocatedBlock().getLocations()) {
                        Assert.assertNotNull((Object)dni);
                    }
                    int numReplicas = dnis.length;
                    LOG.info("Got " + numReplicas + " locs: " + locs);
                    if (numReplicas > expectedReplicas) {
                        cluster.triggerDeletionReports();
                    }
                    cluster.triggerHeartbeats();
                    return numReplicas == expectedReplicas;
                }
                catch (IOException e) {
                    LOG.warn("No block locations yet: " + e.getMessage());
                    return false;
                }
            }
        }, (long)500L, (long)20000L);
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
    }
}

