/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import java.util.Map;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.NoActiveSubclustersException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public abstract class AbstractConfigurableFederationPolicy
implements ConfigurableFederationPolicy {
    private WeightedPolicyInfo policyInfo = null;
    private FederationPolicyInitializationContext policyContext;
    private boolean isDirty;

    @Override
    public void reinitialize(FederationPolicyInitializationContext initializationContext) throws FederationPolicyInitializationException {
        this.isDirty = true;
        FederationPolicyInitializationContextValidator.validate(initializationContext, this.getClass().getCanonicalName());
        WeightedPolicyInfo newPolicyInfo = WeightedPolicyInfo.fromByteBuffer(initializationContext.getSubClusterPolicyConfiguration().getParams());
        if (this.policyInfo != null && this.policyInfo.equals(newPolicyInfo)) {
            this.isDirty = false;
            return;
        }
        this.validate(newPolicyInfo);
        this.setPolicyInfo(newPolicyInfo);
        this.policyContext = initializationContext;
    }

    public void validate(WeightedPolicyInfo newPolicyInfo) throws FederationPolicyInitializationException {
        if (newPolicyInfo == null) {
            throw new FederationPolicyInitializationException("The policy to validate should not be null.");
        }
    }

    public boolean getIsDirty() {
        return this.isDirty;
    }

    public WeightedPolicyInfo getPolicyInfo() {
        return this.policyInfo;
    }

    public void setPolicyInfo(WeightedPolicyInfo policyInfo) {
        this.policyInfo = policyInfo;
    }

    public FederationPolicyInitializationContext getPolicyContext() {
        return this.policyContext;
    }

    public void setPolicyContext(FederationPolicyInitializationContext policyContext) {
        this.policyContext = policyContext;
    }

    protected Map<SubClusterId, SubClusterInfo> getActiveSubclusters() throws YarnException {
        Map<SubClusterId, SubClusterInfo> activeSubclusters = this.getPolicyContext().getFederationStateStoreFacade().getSubClusters(true);
        if (activeSubclusters == null || activeSubclusters.size() < 1) {
            throw new NoActiveSubclustersException("Zero active subclusters, cannot pick where to send job.");
        }
        return activeSubclusters;
    }
}

