/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityLevel;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;

public class AppAllocation {
    private Priority priority;
    private NodeId nodeId;
    private ContainerId containerId;
    private ActivityState activityState;
    private String diagnostic;
    private String queueName;
    private List<ActivityNode> allocationAttempts;
    private long timestamp;

    public AppAllocation(Priority priority, NodeId nodeId, String queueName) {
        this.priority = priority;
        this.nodeId = nodeId;
        this.allocationAttempts = new ArrayList<ActivityNode>();
        this.queueName = queueName;
    }

    public void updateAppContainerStateAndTime(ContainerId cId, ActivityState appState, long ts, String diagnostic) {
        this.timestamp = ts;
        this.containerId = cId;
        this.activityState = appState;
        this.diagnostic = diagnostic;
    }

    public void addAppAllocationActivity(String cId, Integer reqPriority, ActivityState state, String diagnose, ActivityLevel level, NodeId nId, Long allocationRequestId) {
        ActivityNode container = new ActivityNode(cId, null, reqPriority, state, diagnose, level, nId, allocationRequestId);
        this.allocationAttempts.add(container);
        this.activityState = state == ActivityState.REJECTED ? ActivityState.SKIPPED : state;
    }

    public String getNodeId() {
        return this.nodeId == null ? null : this.nodeId.toString();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public ActivityState getActivityState() {
        return this.activityState;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getContainerId() {
        if (this.containerId == null) {
            return null;
        }
        return this.containerId.toString();
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public long getTime() {
        return this.timestamp;
    }

    public List<ActivityNode> getAllocationAttempts() {
        return this.allocationAttempts;
    }

    public AppAllocation filterAllocationAttempts(Set<Integer> requestPriorities, Set<Long> allocationRequestIds) {
        AppAllocation appAllocation = new AppAllocation(this.priority, this.nodeId, this.queueName);
        appAllocation.activityState = this.activityState;
        appAllocation.containerId = this.containerId;
        appAllocation.timestamp = this.timestamp;
        appAllocation.diagnostic = this.diagnostic;
        Predicate<ActivityNode> predicate = e -> !(!CollectionUtils.isEmpty((Collection)requestPriorities) && !requestPriorities.contains(e.getRequestPriority()) || !CollectionUtils.isEmpty((Collection)allocationRequestIds) && !allocationRequestIds.contains(e.getAllocationRequestId()));
        appAllocation.allocationAttempts = this.allocationAttempts.stream().filter(predicate).collect(Collectors.toList());
        return appAllocation;
    }

    public void setAllocationAttempts(List<ActivityNode> allocationAttempts) {
        this.allocationAttempts = allocationAttempts;
    }
}

