/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.rbfbalance;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;

public class MountTableProcedure
extends BalanceProcedure {
    private String mount;
    private String dstPath;
    private String dstNs;
    private Configuration conf;

    public MountTableProcedure() {
    }

    public MountTableProcedure(String name, String nextProcedure, long delayDuration, String mount, String dstPath, String dstNs, Configuration conf) {
        super(name, nextProcedure, delayDuration);
        this.mount = mount;
        this.dstPath = dstPath;
        this.dstNs = dstNs;
        this.conf = conf;
    }

    public boolean execute() throws BalanceProcedure.RetryException, IOException {
        this.updateMountTable();
        return true;
    }

    private void updateMountTable() throws IOException {
        MountTableProcedure.updateMountTableDestination(this.mount, this.dstNs, this.dstPath, this.conf);
        MountTableProcedure.enableWrite(this.mount, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMountTableDestination(String mount, String dstNs, String dstPath, Configuration conf) throws IOException {
        String address = conf.getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
        InetSocketAddress routerSocket = NetUtils.createSocketAddr((String)address);
        try (RouterClient rClient = new RouterClient(routerSocket, conf);){
            MountTableManager mountTable = rClient.getMountTableManager();
            MountTable originalEntry = MountTableProcedure.getMountEntry(mount, mountTable);
            if (originalEntry == null) {
                throw new IOException("Mount table " + mount + " doesn't exist");
            }
            RemoteLocation remoteLocation = new RemoteLocation(dstNs, dstPath, mount);
            originalEntry.setDestinations(Arrays.asList(remoteLocation));
            UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(originalEntry);
            UpdateMountTableEntryResponse response = mountTable.updateMountTableEntry(updateRequest);
            if (!response.getStatus()) {
                throw new IOException("Failed update mount table " + mount);
            }
            rClient.getMountTableManager().refreshMountTableEntries(RefreshMountTableEntriesRequest.newInstance());
        }
    }

    public static MountTable getMountEntry(String mount, MountTableManager mountTable) throws IOException {
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance(mount);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List<MountTable> results = getResponse.getEntries();
        MountTable existingEntry = null;
        for (MountTable result : results) {
            if (!mount.equals(result.getSourcePath())) continue;
            existingEntry = result;
            break;
        }
        return existingEntry;
    }

    static void disableWrite(String mount, Configuration conf) throws IOException {
        MountTableProcedure.setMountReadOnly(mount, true, conf);
    }

    static void enableWrite(String mount, Configuration conf) throws IOException {
        MountTableProcedure.setMountReadOnly(mount, false, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMountReadOnly(String mount, boolean readOnly, Configuration conf) throws IOException {
        String address = conf.getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
        InetSocketAddress routerSocket = NetUtils.createSocketAddr((String)address);
        try (RouterClient rClient = new RouterClient(routerSocket, conf);){
            MountTableManager mountTable = rClient.getMountTableManager();
            MountTable originalEntry = MountTableProcedure.getMountEntry(mount, mountTable);
            if (originalEntry == null) {
                throw new IOException("Mount table " + mount + " doesn't exist");
            }
            originalEntry.setReadOnly(readOnly);
            UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(originalEntry);
            UpdateMountTableEntryResponse response = mountTable.updateMountTableEntry(updateRequest);
            if (!response.getStatus()) {
                throw new IOException("Failed update mount table " + mount + " with readonly=" + readOnly);
            }
            rClient.getMountTableManager().refreshMountTableEntries(RefreshMountTableEntriesRequest.newInstance());
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.mount);
        Text.writeString((DataOutput)out, (String)this.dstPath);
        Text.writeString((DataOutput)out, (String)this.dstNs);
        this.conf.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.mount = Text.readString((DataInput)in);
        this.dstPath = Text.readString((DataInput)in);
        this.dstNs = Text.readString((DataInput)in);
        this.conf = new Configuration(false);
        this.conf.readFields(in);
    }

    @VisibleForTesting
    String getMount() {
        return this.mount;
    }

    @VisibleForTesting
    String getDstPath() {
        return this.dstPath;
    }

    @VisibleForTesting
    String getDstNs() {
        return this.dstNs;
    }
}

