/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.config.event;

import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.shaded.org.ehcache.core.events.CacheEventListenerConfiguration;
import org.apache.hadoop.shaded.org.ehcache.core.events.CacheEventListenerProvider;
import org.apache.hadoop.shaded.org.ehcache.event.CacheEventListener;
import org.apache.hadoop.shaded.org.ehcache.event.EventFiring;
import org.apache.hadoop.shaded.org.ehcache.event.EventOrdering;
import org.apache.hadoop.shaded.org.ehcache.event.EventType;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.classes.ClassInstanceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;

public class DefaultCacheEventListenerConfiguration
extends ClassInstanceConfiguration<CacheEventListener<?, ?>>
implements CacheEventListenerConfiguration<Void> {
    private final EnumSet<EventType> eventsToFireOn;
    private EventFiring eventFiringMode = EventFiring.ASYNCHRONOUS;
    private EventOrdering eventOrderingMode = EventOrdering.UNORDERED;

    public DefaultCacheEventListenerConfiguration(Set<EventType> fireOn, Class<? extends CacheEventListener<?, ?>> clazz, Object ... arguments) {
        super(clazz, arguments);
        if (fireOn.isEmpty()) {
            throw new IllegalArgumentException("Set of event types to fire on must not be empty");
        }
        this.eventsToFireOn = EnumSet.copyOf(fireOn);
    }

    public DefaultCacheEventListenerConfiguration(Set<EventType> fireOn, CacheEventListener<?, ?> listener) {
        super(listener);
        if (fireOn.isEmpty()) {
            throw new IllegalArgumentException("Set of event types to fire on must not be empty");
        }
        this.eventsToFireOn = EnumSet.copyOf(fireOn);
    }

    @Override
    public Class<CacheEventListenerProvider> getServiceType() {
        return CacheEventListenerProvider.class;
    }

    public void setEventFiringMode(EventFiring firingMode) {
        this.eventFiringMode = firingMode;
    }

    public void setEventOrderingMode(EventOrdering orderingMode) {
        this.eventOrderingMode = orderingMode;
    }

    @Override
    public EventFiring firingMode() {
        return this.eventFiringMode;
    }

    @Override
    public EventOrdering orderingMode() {
        return this.eventOrderingMode;
    }

    @Override
    public EnumSet<EventType> fireOn() {
        return this.eventsToFireOn;
    }

    @Override
    public boolean compatibleWith(ServiceConfiguration<?, ?> other) {
        return true;
    }
}

