/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class CloseUtil {
    public static <T extends Throwable> T closeAllAfter(T failure, Object ... objects) {
        Optional<Closeable> closeable = CloseUtil.extractCloseables(Stream.of(objects)).reduce(CloseUtil::composeCloseables);
        if (closeable.isPresent()) {
            try {
                closeable.get().close();
            }
            catch (Throwable t) {
                failure.addSuppressed(t);
            }
        }
        return failure;
    }

    static void closeAll(Object ... objects) throws IOException {
        CloseUtil.closeAll(Stream.of(objects));
    }

    static void closeAll(Stream<Object> objects) throws IOException {
        CloseUtil.chain(CloseUtil.extractCloseables(objects));
    }

    static void chain(Closeable ... objects) throws IOException {
        CloseUtil.chain(Stream.of(objects));
    }

    public static void chain(Stream<Closeable> objects) throws IOException {
        Optional<Closeable> closeable = objects.reduce(CloseUtil::composeCloseables);
        if (closeable.isPresent()) {
            closeable.get().close();
        }
    }

    private static Stream<Closeable> extractCloseables(Stream<Object> objects) {
        return objects.filter(o -> o != null).flatMap(o -> {
            if (o instanceof Collection) {
                return ((Collection)o).stream();
            }
            if (o.getClass().isArray()) {
                return Arrays.stream((Object[])o);
            }
            return Stream.of(o);
        }).filter(o -> o != null).filter(Closeable.class::isInstance).map(Closeable.class::cast);
    }

    private static Closeable composeCloseables(Closeable a, Closeable b) {
        return () -> {
            try {
                a.close();
            }
            finally {
                b.close();
            }
        };
    }
}

