/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.api.records.ContainerQueuingLimit;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.ClusterNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.NodeQueueLoadMonitor;

public class QueueLimitCalculator {
    private final NodeQueueLoadMonitor nodeSelector;
    private final float sigma;
    private final int rangeMin;
    private final int rangeMax;
    private final Stats stats = new Stats();

    QueueLimitCalculator(NodeQueueLoadMonitor selector, float sigma, int rangeMin, int rangeMax) {
        this.nodeSelector = selector;
        this.sigma = sigma;
        this.rangeMax = rangeMax;
        this.rangeMin = rangeMin;
    }

    private int determineThreshold() {
        return (int)((float)this.stats.getMean() + this.sigma * (float)this.stats.getStdev());
    }

    void update() {
        this.stats.update();
    }

    private int getThreshold() {
        int thres = this.determineThreshold();
        return Math.min(this.rangeMax, Math.max(this.rangeMin, thres));
    }

    public ContainerQueuingLimit createContainerQueuingLimit() {
        ContainerQueuingLimit containerQueuingLimit = ContainerQueuingLimit.newInstance();
        if (this.nodeSelector.getComparator() == NodeQueueLoadMonitor.LoadComparator.QUEUE_WAIT_TIME) {
            containerQueuingLimit.setMaxQueueWaitTimeInMs(this.getThreshold());
            containerQueuingLimit.setMaxQueueLength(-1);
        } else {
            containerQueuingLimit.setMaxQueueWaitTimeInMs(-1);
            containerQueuingLimit.setMaxQueueLength(this.getThreshold());
        }
        return containerQueuingLimit;
    }

    class Stats {
        private final AtomicInteger mean = new AtomicInteger(0);
        private final AtomicInteger stdev = new AtomicInteger(0);

        Stats() {
        }

        void update() {
            List<NodeId> sortedNodes = QueueLimitCalculator.this.nodeSelector.getSortedNodes();
            if (sortedNodes.size() > 0) {
                int sum = 0;
                for (NodeId n : sortedNodes) {
                    sum += this.getMetric(this.getNode(n));
                }
                this.mean.set(sum / sortedNodes.size());
                int sqrSumMean = 0;
                for (NodeId n : sortedNodes) {
                    int val = this.getMetric(this.getNode(n));
                    sqrSumMean = (int)((double)sqrSumMean + Math.pow(val - this.mean.get(), 2.0));
                }
                this.stdev.set((int)Math.round(Math.sqrt((float)sqrSumMean / (float)sortedNodes.size())));
            }
        }

        private ClusterNode getNode(NodeId nId) {
            return QueueLimitCalculator.this.nodeSelector.getClusterNodes().get(nId);
        }

        private int getMetric(ClusterNode cn) {
            return cn != null ? ((NodeQueueLoadMonitor.LoadComparator)QueueLimitCalculator.this.nodeSelector.getComparator()).getMetric(cn) : 0;
        }

        public int getMean() {
            return this.mean.get();
        }

        public int getStdev() {
            return this.stdev.get();
        }
    }
}

