/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineAggregationTrack;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpTimelineWriterImpl
extends AbstractService
implements TimelineWriter {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpTimelineWriterImpl.class);

    public NoOpTimelineWriterImpl() {
        super(NoOpTimelineWriterImpl.class.getName());
        LOG.info("NoOpTimelineWriter is configured. All the writes to the backend are ignored");
    }

    @Override
    public TimelineWriteResponse write(TimelineCollectorContext context, TimelineEntities data, UserGroupInformation callerUgi) throws IOException {
        LOG.debug("NoOpTimelineWriter is configured. Not storing TimelineEntities.");
        return new TimelineWriteResponse();
    }

    @Override
    public TimelineWriteResponse write(TimelineCollectorContext context, TimelineDomain domain) throws IOException {
        LOG.debug("NoOpTimelineWriter is configured. Not storing TimelineEntities.");
        return new TimelineWriteResponse();
    }

    @Override
    public TimelineWriteResponse aggregate(TimelineEntity data, TimelineAggregationTrack track) throws IOException {
        LOG.debug("NoOpTimelineWriter is configured. Not aggregating TimelineEntities.");
        return new TimelineWriteResponse();
    }

    @Override
    public void flush() throws IOException {
        LOG.debug("NoOpTimelineWriter is configured. Ignoring flush call");
    }

    @Override
    public TimelineHealth getHealthStatus() {
        return new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "NoOpTimelineWriter is configured. ");
    }
}

