/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineServerUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimestampGenerator;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowScanner;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowScannerOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowRunCoprocessor
implements RegionCoprocessor,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(FlowRunCoprocessor.class);
    private Region region;
    private final TimestampGenerator timestampGenerator = new TimestampGenerator();

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        if (e instanceof RegionCoprocessorEnvironment) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            this.region = env.getRegion();
        }
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
        Map attributes = put.getAttributesMap();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (attributes != null && attributes.size() > 0) {
            for (Map.Entry<String, byte[]> entry : attributes.entrySet()) {
                Tag t = HBaseTimelineServerUtils.getTagFromAttribute(entry);
                if (t == null) continue;
                tags.add(t);
            }
            byte[] tagByteArray = HBaseTimelineServerUtils.convertTagListToByteArray(tags);
            TreeMap treeMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (Map.Entry entry : put.getFamilyCellMap().entrySet()) {
                ArrayList<Cell> newCells = new ArrayList<Cell>(((List)entry.getValue()).size());
                for (Cell cell : (List)entry.getValue()) {
                    long cellTimestamp = this.getCellTimestamp(cell.getTimestamp(), tags);
                    newCells.add(CellUtil.createCell((byte[])CellUtil.cloneRow((Cell)cell), (byte[])CellUtil.cloneFamily((Cell)cell), (byte[])CellUtil.cloneQualifier((Cell)cell), (long)cellTimestamp, (KeyValue.Type)KeyValue.Type.Put, (byte[])CellUtil.cloneValue((Cell)cell), (byte[])tagByteArray));
                }
                treeMap.put(entry.getKey(), newCells);
            }
            put.setFamilyCellMap(treeMap);
        }
    }

    private long getCellTimestamp(long timestamp, List<Tag> tags) {
        if (timestamp == Long.MAX_VALUE) {
            return this.timestampGenerator.getUniqueTimestamp();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        Scan scan = new Scan(get);
        scan.setMaxVersions();
        try (FlowScanner scanner = null;){
            scanner = new FlowScanner((RegionCoprocessorEnvironment)e.getEnvironment(), scan, (InternalScanner)this.region.getScanner(scan), FlowScannerOperation.READ);
            scanner.next(results);
            e.bypass();
        }
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
        scan.setMaxVersions();
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner scanner) throws IOException {
        return new FlowScanner((RegionCoprocessorEnvironment)e.getEnvironment(), scan, (InternalScanner)scanner, FlowScannerOperation.READ);
    }

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker cycleTracker) throws IOException {
        if (LOG.isDebugEnabled() && store != null) {
            LOG.debug("preFlush store = " + store.getColumnFamilyName() + " flushableSize=" + store.getFlushableSize() + " flushedCellsCount=" + store.getFlushedCellsCount() + " compactedCellsCount=" + store.getCompactedCellsCount() + " majorCompactedCellsCount=" + store.getMajorCompactedCellsCount() + " memstoreSize=" + store.getMemStoreSize() + " size=" + store.getSize() + " storeFilesCount=" + store.getStorefilesCount());
        }
        return new FlowScanner((RegionCoprocessorEnvironment)c.getEnvironment(), scanner, FlowScannerOperation.FLUSH);
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, FlushLifeCycleTracker tracker) {
        if (LOG.isDebugEnabled() && store != null) {
            LOG.debug("postFlush store = " + store.getColumnFamilyName() + " flushableSize=" + store.getFlushableSize() + " flushedCellsCount=" + store.getFlushedCellsCount() + " compactedCellsCount=" + store.getCompactedCellsCount() + " majorCompactedCellsCount=" + store.getMajorCompactedCellsCount() + " memstoreSize=" + store.getMemStoreSize() + " size=" + store.getSize() + " storeFilesCount=" + store.getStorefilesCount());
        }
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        FlowScannerOperation requestOp = FlowScannerOperation.MINOR_COMPACTION;
        if (request != null) {
            requestOp = request.isMajor() ? FlowScannerOperation.MAJOR_COMPACTION : FlowScannerOperation.MINOR_COMPACTION;
            LOG.info("Compactionrequest= " + request.toString() + " " + requestOp.toString() + " RegionName=" + ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString());
        }
        return new FlowScanner((RegionCoprocessorEnvironment)e.getEnvironment(), scanner, requestOp);
    }
}

