/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.AbfsHttpConstants;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsInvalidChecksumException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidFileSystemPropertyException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.SASTokenProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.StorageErrorResponseSchema;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformerInterface;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsApacheHttpClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientRenameResult;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsPermission;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingInterceptFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.KeepAliveCache;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.services.StaticRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.TimerFunctionality;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.DateTimeUtils;
import org.apache.hadoop.fs.azurebfs.utils.EncryptionType;
import org.apache.hadoop.fs.azurebfs.utils.MetricFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.FutureCallback;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableScheduledFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbfsClient
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    public static final String HUNDRED_CONTINUE_USER_AGENT = " 100-continue;";
    public static final String ABFS_CLIENT_TIMER_THREAD_NAME = "abfs-timer-client";
    private final URL baseUrl;
    private final SharedKeyCredentials sharedKeyCredentials;
    private AbfsHttpConstants.ApiVersion xMsVersion = AbfsHttpConstants.ApiVersion.getCurrentVersion();
    private final ExponentialRetryPolicy exponentialRetryPolicy;
    private final StaticRetryPolicy staticRetryPolicy;
    private final String filesystem;
    private final AbfsConfiguration abfsConfiguration;
    private final String userAgent;
    private final AbfsPerfTracker abfsPerfTracker;
    private String clientProvidedEncryptionKey = null;
    private String clientProvidedEncryptionKeySHA = null;
    private final IdentityTransformerInterface identityTransformer;
    private final String userName;
    private String primaryUserGroup;
    private final String accountName;
    private final AuthType authType;
    private AccessTokenProvider tokenProvider;
    private SASTokenProvider sasTokenProvider;
    private final AbfsCounters abfsCounters;
    private Timer timer;
    private final String abfsMetricUrl;
    private boolean isMetricCollectionEnabled = false;
    private final MetricFormat metricFormat;
    private final AtomicBoolean isMetricCollectionStopped;
    private final int metricAnalysisPeriod;
    private final int metricIdlePeriod;
    private EncryptionContextProvider encryptionContextProvider = null;
    private EncryptionType encryptionType = EncryptionType.NONE;
    private final AbfsThrottlingIntercept intercept;
    private final ListeningScheduledExecutorService executorService;
    private boolean renameResilience;
    private TimerTask runningTimerTask;
    private boolean isSendMetricCall;
    private SharedKeyCredentials metricSharedkeyCredentials = null;
    private KeepAliveCache keepAliveCache;
    private AbfsApacheHttpClient abfsApacheHttpClient;
    private static boolean isNamespaceEnabled = false;
    protected static final LogExactlyOnce ABFS_METADATA_INCOMPLETE_RENAME_FAILURE = new LogExactlyOnce(LOG);

    private AbfsClient(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        this.baseUrl = baseUrl;
        this.sharedKeyCredentials = sharedKeyCredentials;
        String baseUrlString = baseUrl.toString();
        this.filesystem = baseUrlString.substring(baseUrlString.lastIndexOf("/") + 1);
        this.abfsConfiguration = abfsConfiguration;
        this.exponentialRetryPolicy = abfsClientContext.getExponentialRetryPolicy();
        this.staticRetryPolicy = abfsClientContext.getStaticRetryPolicy();
        this.accountName = abfsConfiguration.getAccountName().substring(0, abfsConfiguration.getAccountName().indexOf("."));
        this.authType = abfsConfiguration.getAuthType(this.accountName);
        this.intercept = AbfsThrottlingInterceptFactory.getInstance(this.accountName, abfsConfiguration);
        this.renameResilience = abfsConfiguration.getRenameResilience();
        if (encryptionContextProvider != null) {
            this.encryptionContextProvider = encryptionContextProvider;
            this.encryptionType = EncryptionType.ENCRYPTION_CONTEXT;
        } else if (abfsConfiguration.getEncodedClientProvidedEncryptionKey() != null) {
            this.clientProvidedEncryptionKey = abfsConfiguration.getEncodedClientProvidedEncryptionKey();
            this.clientProvidedEncryptionKeySHA = abfsConfiguration.getEncodedClientProvidedEncryptionKeySHA();
            this.encryptionType = EncryptionType.GLOBAL_KEY;
        }
        String sslProviderName = null;
        if (this.baseUrl.toString().startsWith("https")) {
            try {
                LOG.trace("Initializing DelegatingSSLSocketFactory with {} SSL Channel Mode", (Object)this.abfsConfiguration.getPreferredSSLFactoryOption());
                DelegatingSSLSocketFactory.initializeDefaultFactory((DelegatingSSLSocketFactory.SSLChannelMode)this.abfsConfiguration.getPreferredSSLFactoryOption());
                sslProviderName = DelegatingSSLSocketFactory.getDefaultFactory().getProviderName();
            }
            catch (IOException e) {
                LOG.trace("NonCritFailure: DelegatingSSLSocketFactory Init failed : {}", (Object)e.getMessage());
            }
        }
        if (abfsConfiguration.getPreferredHttpOperationType() == HttpOperationType.APACHE_HTTP_CLIENT) {
            this.keepAliveCache = new KeepAliveCache(abfsConfiguration);
            this.abfsApacheHttpClient = new AbfsApacheHttpClient(DelegatingSSLSocketFactory.getDefaultFactory(), abfsConfiguration.getHttpReadTimeout(), this.keepAliveCache);
        }
        this.userAgent = this.initializeUserAgent(abfsConfiguration, sslProviderName);
        this.abfsPerfTracker = abfsClientContext.getAbfsPerfTracker();
        this.abfsCounters = abfsClientContext.getAbfsCounters();
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("AbfsClient Lease Ops").setDaemon(true).build();
        this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)HadoopExecutors.newScheduledThreadPool((int)this.abfsConfiguration.getNumLeaseThreads(), (ThreadFactory)tf));
        this.metricFormat = abfsConfiguration.getMetricFormat();
        this.isMetricCollectionStopped = new AtomicBoolean(false);
        this.metricAnalysisPeriod = abfsConfiguration.getMetricAnalysisTimeout();
        this.metricIdlePeriod = abfsConfiguration.getMetricIdleTimeout();
        if (StringUtils.isNotEmpty((CharSequence)this.metricFormat.toString())) {
            String metricAccountName = abfsConfiguration.getMetricAccount();
            String metricAccountKey = abfsConfiguration.getMetricAccountKey();
            if (StringUtils.isNotEmpty((CharSequence)metricAccountName) && StringUtils.isNotEmpty((CharSequence)metricAccountKey)) {
                this.isMetricCollectionEnabled = true;
                this.abfsCounters.initializeMetrics(this.metricFormat);
                int dotIndex = metricAccountName.indexOf(".");
                if (dotIndex <= 0) {
                    throw new InvalidUriException(metricAccountName + " - account name is not fully qualified.");
                }
                try {
                    this.metricSharedkeyCredentials = new SharedKeyCredentials(metricAccountName.substring(0, dotIndex), metricAccountKey);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Exception while initializing metric credentials ", e);
                }
            }
        }
        if (this.isMetricCollectionEnabled) {
            this.timer = new Timer(ABFS_CLIENT_TIMER_THREAD_NAME, true);
            this.timer.schedule((TimerTask)new TimerTaskImpl(), this.metricIdlePeriod, (long)this.metricIdlePeriod);
        }
        this.abfsMetricUrl = abfsConfiguration.getMetricUri();
        Class identityTransformerClass = abfsConfiguration.getRawConfiguration().getClass("fs.azure.identity.transformer.class", IdentityTransformer.class, IdentityTransformerInterface.class);
        try {
            this.identityTransformer = (IdentityTransformerInterface)identityTransformerClass.getConstructor(Configuration.class).newInstance(abfsConfiguration.getRawConfiguration());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("IdentityTransformer Init Falied", (Throwable)e);
            throw new IOException(e);
        }
        LOG.trace("IdentityTransformer init complete");
        UserGroupInformation userGroupInformation = UserGroupInformation.getCurrentUser();
        this.userName = userGroupInformation.getShortUserName();
        LOG.trace("UGI init complete");
        if (!abfsConfiguration.getSkipUserGroupMetadataDuringInitialization()) {
            try {
                this.primaryUserGroup = userGroupInformation.getPrimaryGroupName();
            }
            catch (IOException ex) {
                LOG.error("Failed to get primary group for {}, using user name as primary group name", (Object)this.userName);
                this.primaryUserGroup = this.userName;
            }
        } else {
            this.primaryUserGroup = this.userName;
        }
        LOG.trace("primaryUserGroup is {}", (Object)this.primaryUserGroup);
    }

    public AbfsClient(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, AccessTokenProvider tokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        this(baseUrl, sharedKeyCredentials, abfsConfiguration, encryptionContextProvider, abfsClientContext);
        this.tokenProvider = tokenProvider;
    }

    public AbfsClient(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, SASTokenProvider sasTokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        this(baseUrl, sharedKeyCredentials, abfsConfiguration, encryptionContextProvider, abfsClientContext);
        this.sasTokenProvider = sasTokenProvider;
    }

    @Override
    public void close() throws IOException {
        if (this.isMetricCollectionEnabled && this.runningTimerTask != null) {
            this.runningTimerTask.cancel();
            this.timer.cancel();
        }
        if (this.keepAliveCache != null) {
            this.keepAliveCache.close();
        }
        if (this.abfsApacheHttpClient != null) {
            this.abfsApacheHttpClient.close();
        }
        if (this.runningTimerTask != null) {
            this.runningTimerTask.cancel();
            this.timer.purge();
        }
        if (this.tokenProvider instanceof Closeable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{(Closeable)((Object)this.tokenProvider)});
        }
        HadoopExecutors.shutdown((ExecutorService)this.executorService, (Logger)LOG, (long)0L, (TimeUnit)TimeUnit.SECONDS);
    }

    public String getFileSystem() {
        return this.filesystem;
    }

    protected AbfsPerfTracker getAbfsPerfTracker() {
        return this.abfsPerfTracker;
    }

    ExponentialRetryPolicy getExponentialRetryPolicy() {
        return this.exponentialRetryPolicy;
    }

    StaticRetryPolicy getStaticRetryPolicy() {
        return this.staticRetryPolicy;
    }

    public AbfsRetryPolicy getRetryPolicy(String failureReason) {
        return "CT".equals(failureReason) && this.getAbfsConfiguration().getStaticRetryForConnectionTimeoutEnabled() ? this.getStaticRetryPolicy() : this.getExponentialRetryPolicy();
    }

    SharedKeyCredentials getSharedKeyCredentials() {
        return this.sharedKeyCredentials;
    }

    SharedKeyCredentials getMetricSharedkeyCredentials() {
        return this.metricSharedkeyCredentials;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    AbfsThrottlingIntercept getIntercept() {
        return this.intercept;
    }

    @VisibleForTesting
    protected abstract List<AbfsHttpHeader> createDefaultHeaders();

    @VisibleForTesting
    public abstract List<AbfsHttpHeader> createDefaultHeaders(AbfsHttpConstants.ApiVersion var1);

    protected List<AbfsHttpHeader> createCommonHeaders(AbfsHttpConstants.ApiVersion xMsVersion) {
        ArrayList<AbfsHttpHeader> requestHeaders = new ArrayList<AbfsHttpHeader>();
        requestHeaders.add(new AbfsHttpHeader("x-ms-version", xMsVersion.toString()));
        requestHeaders.add(new AbfsHttpHeader("Accept-Charset", "utf-8"));
        requestHeaders.add(new AbfsHttpHeader("Content-Type", ""));
        requestHeaders.add(new AbfsHttpHeader("User-Agent", this.userAgent));
        return requestHeaders;
    }

    protected void addEncryptionKeyRequestHeaders(String path, List<AbfsHttpHeader> requestHeaders, boolean isCreateFileRequest, ContextEncryptionAdapter contextEncryptionAdapter, TracingContext tracingContext) throws AzureBlobFileSystemException {
        String encodedKeySHA256;
        String encodedKey;
        switch (this.encryptionType) {
            case GLOBAL_KEY: {
                encodedKey = this.clientProvidedEncryptionKey;
                encodedKeySHA256 = this.clientProvidedEncryptionKeySHA;
                break;
            }
            case ENCRYPTION_CONTEXT: {
                if (isCreateFileRequest) {
                    requestHeaders.add(new AbfsHttpHeader("x-ms-encryption-context", contextEncryptionAdapter.getEncodedContext()));
                }
                encodedKey = contextEncryptionAdapter.getEncodedKey();
                encodedKeySHA256 = contextEncryptionAdapter.getEncodedKeySHA();
                break;
            }
            default: {
                return;
            }
        }
        requestHeaders.add(new AbfsHttpHeader("x-ms-encryption-key", encodedKey));
        requestHeaders.add(new AbfsHttpHeader("x-ms-encryption-key-sha256", encodedKeySHA256));
        requestHeaders.add(new AbfsHttpHeader("x-ms-encryption-algorithm", "AES256"));
    }

    protected AbfsUriQueryBuilder createDefaultUriQueryBuilder() {
        AbfsUriQueryBuilder abfsUriQueryBuilder = new AbfsUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("timeout", "90");
        return abfsUriQueryBuilder;
    }

    public abstract AbfsRestOperation createFilesystem(TracingContext var1) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation setFilesystemProperties(Hashtable<String, String> var1, TracingContext var2) throws AzureBlobFileSystemException;

    public abstract ListResponseData listPath(String var1, boolean var2, int var3, String var4, TracingContext var5, URI var6) throws IOException;

    public abstract List<FileStatus> postListProcessing(String var1, List<FileStatus> var2, TracingContext var3, URI var4) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation getFilesystemProperties(TracingContext var1) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation deleteFilesystem(TracingContext var1) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation createPath(String var1, boolean var2, boolean var3, AzureBlobFileSystemStore.Permissions var4, boolean var5, String var6, ContextEncryptionAdapter var7, TracingContext var8) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation conditionalCreateOverwriteFile(String var1, FileSystem.Statistics var2, AzureBlobFileSystemStore.Permissions var3, boolean var4, ContextEncryptionAdapter var5, TracingContext var6) throws IOException;

    public abstract void createNonRecursivePreCheck(Path var1, TracingContext var2) throws IOException;

    public abstract AbfsRestOperation acquireLease(String var1, int var2, String var3, TracingContext var4) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation renewLease(String var1, String var2, TracingContext var3) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation releaseLease(String var1, String var2, TracingContext var3) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation breakLease(String var1, TracingContext var2) throws AzureBlobFileSystemException;

    public abstract AbfsClientRenameResult renamePath(String var1, String var2, String var3, TracingContext var4, String var5, boolean var6) throws IOException;

    public abstract boolean checkIsDir(AbfsHttpOperation var1);

    @VisibleForTesting
    AbfsRestOperation createRenameRestOperation(URL url, List<AbfsHttpHeader> requestHeaders) {
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.RenamePath, "PUT", url, requestHeaders);
        return op;
    }

    protected void incrementAbfsRenamePath() {
        this.abfsCounters.incrementCounter(AbfsStatistic.RENAME_PATH_ATTEMPTS, 1L);
    }

    public boolean renameIdempotencyCheckOp(String source, String sourceEtag, AbfsRestOperation op, String destination, TracingContext tracingContext) {
        Preconditions.checkArgument((boolean)op.hasResult(), (Object)"Operations has null HTTP response");
        LOG.debug("rename({}, {}) failure {}; retry={} etag {}", new Object[]{source, destination, op.getResult().getStatusCode(), op.isARetriedRequest(), sourceEtag});
        if (!op.isARetriedRequest() || op.getResult().getStatusCode() != 404) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)sourceEtag)) {
            LOG.info("rename {} to {} failed, checking etag of destination", (Object)source, (Object)destination);
            try {
                AbfsRestOperation destStatusOp = this.getPathStatus(destination, false, tracingContext, null);
                AbfsHttpOperation result = destStatusOp.getResult();
                boolean recovered = result.getStatusCode() == 200 && sourceEtag.equals(AzureBlobFileSystemStore.extractEtagHeader(result));
                LOG.info("File rename has taken place: recovery {}", (Object)(recovered ? "succeeded" : "failed"));
                return recovered;
            }
            catch (AzureBlobFileSystemException ex) {
                LOG.debug("Failed to get status of path {}", (Object)destination, (Object)ex);
            }
        } else {
            LOG.debug("No source etag; unable to probe for the operation's success");
        }
        return false;
    }

    public abstract AbfsRestOperation append(String var1, byte[] var2, AppendRequestParameters var3, String var4, ContextEncryptionAdapter var5, TracingContext var6) throws AzureBlobFileSystemException;

    public abstract boolean checkUserError(int var1);

    protected boolean isMd5ChecksumError(AbfsRestOperationException e) {
        AzureServiceErrorCode storageErrorCode = e.getErrorCode();
        return storageErrorCode == AzureServiceErrorCode.MD5_MISMATCH;
    }

    public boolean appendSuccessCheckOp(AbfsRestOperation op, String path, long length, TracingContext tracingContext) throws AzureBlobFileSystemException {
        String fileLength;
        AbfsRestOperation destStatusOp;
        if (op.isARetriedRequest() && op.getResult().getStatusCode() == 400 && (destStatusOp = this.getPathStatus(path, false, tracingContext, null)).getResult().getStatusCode() == 200 && length <= Long.parseLong(fileLength = destStatusOp.getResult().getResponseHeader("Content-Length"))) {
            LOG.debug("Returning success response from append blob idempotency code");
            return true;
        }
        return false;
    }

    public abstract AbfsRestOperation flush(String var1, long var2, boolean var4, boolean var5, String var6, String var7, ContextEncryptionAdapter var8, TracingContext var9) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation flush(byte[] var1, String var2, boolean var3, String var4, String var5, String var6, ContextEncryptionAdapter var7, TracingContext var8) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation setPathProperties(String var1, Hashtable<String, String> var2, TracingContext var3, ContextEncryptionAdapter var4) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation getPathStatus(String var1, boolean var2, TracingContext var3, ContextEncryptionAdapter var4) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation read(String var1, long var2, byte[] var4, int var5, int var6, String var7, String var8, ContextEncryptionAdapter var9, TracingContext var10) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation deletePath(String var1, boolean var2, String var3, TracingContext var4) throws AzureBlobFileSystemException;

    public AbfsRestOperation deleteIdempotencyCheckOp(AbfsRestOperation op) {
        Preconditions.checkArgument((boolean)op.hasResult(), (Object)"Operations has null HTTP response");
        if (op.isARetriedRequest() && op.getResult().getStatusCode() == 404) {
            LOG.debug("Returning success response from delete idempotency logic");
            return this.getSuccessOp(AbfsRestOperationType.DeletePath, "DELETE", op.getUrl(), op.getRequestHeaders());
        }
        return op;
    }

    public abstract AbfsRestOperation setOwner(String var1, String var2, String var3, TracingContext var4) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation setPermission(String var1, String var2, TracingContext var3) throws AzureBlobFileSystemException;

    public AbfsRestOperation setAcl(String path, String aclSpecString, TracingContext tracingContext) throws AzureBlobFileSystemException {
        return this.setAcl(path, aclSpecString, "", tracingContext);
    }

    public abstract AbfsRestOperation setAcl(String var1, String var2, String var3, TracingContext var4) throws AzureBlobFileSystemException;

    public AbfsRestOperation getAclStatus(String path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        return this.getAclStatus(path, this.abfsConfiguration.isUpnUsed(), tracingContext);
    }

    public abstract AbfsRestOperation getAclStatus(String var1, boolean var2, TracingContext var3) throws AzureBlobFileSystemException;

    public abstract AbfsRestOperation checkAccess(String var1, String var2, TracingContext var3) throws AzureBlobFileSystemException;

    public static String getDirectoryQueryParameter(String path) {
        String directory = path;
        if (Strings.isNullOrEmpty((String)directory)) {
            directory = "";
        } else if (directory.charAt(0) == '/') {
            directory = directory.substring(1);
        }
        return directory;
    }

    protected String appendSASTokenToQuery(String path, String operation, AbfsUriQueryBuilder queryBuilder) throws SASTokenProviderException {
        return this.appendSASTokenToQuery(path, operation, queryBuilder, null);
    }

    protected String appendSASTokenToQuery(String path, String operation, AbfsUriQueryBuilder queryBuilder, String cachedSasToken) throws SASTokenProviderException {
        String sasToken = null;
        if (this.authType == AuthType.SAS) {
            try {
                LOG.trace("Fetch SAS token for {} on {}", (Object)operation, (Object)path);
                if (cachedSasToken == null) {
                    sasToken = this.sasTokenProvider.getSASToken(this.accountName, this.filesystem, path, operation);
                    if (sasToken == null || sasToken.isEmpty()) {
                        throw new UnsupportedOperationException("SASToken received is empty or null");
                    }
                } else {
                    sasToken = cachedSasToken;
                    LOG.trace("Using cached SAS token.");
                }
                if (sasToken.charAt(0) == '?') {
                    sasToken = sasToken.substring(1);
                }
                queryBuilder.setSASToken(sasToken);
                LOG.trace("SAS token fetch complete for {} on {}", (Object)operation, (Object)path);
            }
            catch (Exception ex) {
                throw new SASTokenProviderException(String.format("Failed to acquire a SAS token for %s on %s due to %s", operation, path, ex.toString()));
            }
        }
        return sasToken;
    }

    @VisibleForTesting
    protected URL createRequestUrl(String query) throws AzureBlobFileSystemException {
        return this.createRequestUrl("", query);
    }

    @VisibleForTesting
    protected URL createRequestUrl(String path, String query) throws AzureBlobFileSystemException {
        return this.createRequestUrl(this.baseUrl, path, query);
    }

    @VisibleForTesting
    protected URL createRequestUrl(URL baseUrl, String path, String query) throws AzureBlobFileSystemException {
        URL url;
        String encodedPath = path;
        try {
            encodedPath = AbfsClient.urlEncode(path);
        }
        catch (AzureBlobFileSystemException ex) {
            LOG.debug("Unexpected error.", (Throwable)ex);
            throw new InvalidUriException(path);
        }
        StringBuilder sb = new StringBuilder();
        if (baseUrl == null) {
            throw new InvalidUriException("URL provided is null");
        }
        sb.append(baseUrl.toString());
        sb.append(encodedPath);
        sb.append(query);
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            throw new InvalidUriException("URL is malformed" + sb.toString());
        }
        return url;
    }

    public static String urlEncode(String value) throws AzureBlobFileSystemException {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidUriException(value);
        }
        return encodedString;
    }

    public synchronized String getAccessToken() throws IOException {
        if (this.tokenProvider != null) {
            return "Bearer " + this.tokenProvider.getToken().getAccessToken();
        }
        return null;
    }

    protected Boolean getIsPaginatedDeleteEnabled() {
        return this.abfsConfiguration.isPaginatedDeleteEnabled();
    }

    protected Boolean isPaginatedDelete(boolean isRecursiveDelete, boolean isNamespaceEnabled) {
        return this.getIsPaginatedDeleteEnabled() != false && isNamespaceEnabled && isRecursiveDelete;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public EncryptionContextProvider getEncryptionContextProvider() {
        return this.encryptionContextProvider;
    }

    @VisibleForTesting
    String initializeUserAgent(AbfsConfiguration abfsConfiguration, String sslProviderName) {
        StringBuilder sb = new StringBuilder();
        sb.append("APN/1.0");
        sb.append(" ");
        sb.append(AbfsHttpConstants.CLIENT_VERSION);
        sb.append(" ");
        sb.append("(");
        sb.append(System.getProperty("java.vendor").replaceAll(" ", ""));
        sb.append(" ");
        sb.append("JavaJRE");
        sb.append(" ");
        sb.append(System.getProperty("java.version"));
        sb.append(";");
        sb.append(" ");
        sb.append(System.getProperty("os.name").replaceAll(" ", ""));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("/");
        sb.append(System.getProperty("os.arch"));
        sb.append(";");
        this.appendIfNotEmpty(sb, sslProviderName, true);
        this.appendIfNotEmpty(sb, ExtensionHelper.getUserAgentSuffix(this.tokenProvider, ""), true);
        if (abfsConfiguration.isExpectHeaderEnabled()) {
            sb.append(" ");
            sb.append("100-continue");
            sb.append(";");
        }
        sb.append(" ").append((Object)abfsConfiguration.getPreferredHttpOperationType()).append(";");
        sb.append(" ");
        sb.append(abfsConfiguration.getClusterName());
        sb.append("/");
        sb.append(abfsConfiguration.getClusterType());
        sb.append(")");
        this.appendIfNotEmpty(sb, abfsConfiguration.getCustomUserAgentPrefix(), false);
        return String.format(Locale.ROOT, sb.toString(), new Object[0]);
    }

    private void appendIfNotEmpty(StringBuilder sb, String regEx, boolean shouldAppendSemiColon) {
        if (regEx == null || regEx.trim().isEmpty()) {
            return;
        }
        sb.append(" ");
        sb.append(regEx);
        if (shouldAppendSemiColon) {
            sb.append(";");
        }
    }

    protected void addCheckSumHeaderForWrite(List<AbfsHttpHeader> requestHeaders, AppendRequestParameters reqParams, byte[] buffer) throws AbfsRestOperationException {
        String md5Hash = this.computeMD5Hash(buffer, reqParams.getoffset(), reqParams.getLength());
        requestHeaders.add(new AbfsHttpHeader("Content-MD5", md5Hash));
    }

    protected void verifyCheckSumForRead(byte[] buffer, AbfsHttpOperation result, int bufferOffset) throws AbfsRestOperationException {
        String md5HashActual;
        int numberOfBytesRead = (int)result.getBytesReceived();
        if (numberOfBytesRead == 0) {
            return;
        }
        String md5HashComputed = this.computeMD5Hash(buffer, bufferOffset, numberOfBytesRead);
        if (!md5HashComputed.equals(md5HashActual = result.getResponseHeader("Content-MD5"))) {
            LOG.debug("Md5 Mismatch Error in Read Operation. Server returned Md5: {}, Client computed Md5: {}", (Object)md5HashActual, (Object)md5HashComputed);
            throw new AbfsInvalidChecksumException(result.getRequestId());
        }
    }

    protected boolean isChecksumValidationEnabled(List<AbfsHttpHeader> requestHeaders, AbfsHttpHeader rangeHeader, int bufferLength) {
        return this.getAbfsConfiguration().getIsChecksumValidationEnabled() && requestHeaders.contains(rangeHeader) && bufferLength <= 0x400000;
    }

    protected boolean isChecksumValidationEnabled() {
        return this.getAbfsConfiguration().getIsChecksumValidationEnabled();
    }

    @VisibleForTesting
    public String computeMD5Hash(byte[] data, int off, int len) throws AbfsRestOperationException {
        try {
            MessageDigest md5Digest = MessageDigest.getInstance("MD5");
            md5Digest.update(data, off, len);
            byte[] md5Bytes = md5Digest.digest();
            return Base64.getEncoder().encodeToString(md5Bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AbfsDriverException(ex);
        }
    }

    @VisibleForTesting
    URL getBaseUrl() {
        return this.baseUrl;
    }

    @VisibleForTesting
    public SASTokenProvider getSasTokenProvider() {
        return this.sasTokenProvider;
    }

    @VisibleForTesting
    void setEncryptionContextProvider(EncryptionContextProvider provider) {
        this.encryptionContextProvider = provider;
    }

    public AbfsCounters getAbfsCounters() {
        return this.abfsCounters;
    }

    public AbfsHttpConstants.ApiVersion getxMsVersion() {
        return this.xMsVersion;
    }

    protected AbfsConfiguration getAbfsConfiguration() {
        return this.abfsConfiguration;
    }

    public int getNumLeaseThreads() {
        return this.abfsConfiguration.getNumLeaseThreads();
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit timeUnit) {
        return this.executorService.schedule(callable, delay, timeUnit);
    }

    public ListenableFuture<?> submit(Runnable runnable) {
        return this.executorService.submit(runnable);
    }

    public <V> void addCallback(ListenableFuture<V> future, FutureCallback<V> callback) {
        Futures.addCallback(future, callback, (Executor)this.executorService);
    }

    @VisibleForTesting
    protected AccessTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    private TracingContext getMetricTracingContext() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "UnknownHost";
        }
        return new TracingContext(TracingContext.validateClientCorrelationID(this.abfsConfiguration.getClientCorrelationId()), hostName, FSOperationType.GET_ATTR, true, this.abfsConfiguration.getTracingHeaderFormat(), null, this.abfsCounters.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean timerOrchestrator(TimerFunctionality timerFunctionality, TimerTask timerTask) {
        switch (timerFunctionality) {
            case RESUME: {
                if (!this.isMetricCollectionEnabled || !this.isMetricCollectionStopped.get()) break;
                AbfsClient abfsClient = this;
                synchronized (abfsClient) {
                    if (this.isMetricCollectionStopped.get()) {
                        this.resumeTimer();
                    }
                    break;
                }
            }
            case SUSPEND: {
                long now = System.currentTimeMillis();
                long lastExecutionTime = this.abfsCounters.getLastExecutionTime().get();
                if (!this.isMetricCollectionEnabled || now - lastExecutionTime < (long)this.metricAnalysisPeriod) break;
                AbfsClient abfsClient = this;
                synchronized (abfsClient) {
                    if (!this.isMetricCollectionStopped.get()) {
                        timerTask.cancel();
                        this.timer.purge();
                        this.isMetricCollectionStopped.set(true);
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    private void resumeTimer() {
        this.isMetricCollectionStopped.set(false);
        this.timer.schedule((TimerTask)new TimerTaskImpl(), this.metricIdlePeriod, (long)this.metricIdlePeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMetricCall(TracingContext tracingContext) throws IOException {
        this.isSendMetricCall = true;
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = UriUtils.changeUrlFromBlobToDfs(this.createRequestUrl(new URL(this.abfsMetricUrl), "", abfsUriQueryBuilder.toString()));
        AbfsRestOperation op = this.getAbfsRestOperation(AbfsRestOperationType.GetFileSystemProperties, "HEAD", url, requestHeaders);
        try {
            op.execute(tracingContext);
        }
        finally {
            this.isSendMetricCall = false;
        }
    }

    public boolean isSendMetricCall() {
        return this.isSendMetricCall;
    }

    public boolean isMetricCollectionEnabled() {
        return this.isMetricCollectionEnabled;
    }

    AbfsRestOperation getAbfsRestOperation(AbfsRestOperationType operationType, String httpMethod, URL url, List<AbfsHttpHeader> requestHeaders, byte[] buffer, int bufferOffset, int bufferLength, String sasTokenForReuse) {
        return new AbfsRestOperation(operationType, this, httpMethod, url, requestHeaders, buffer, bufferOffset, bufferLength, sasTokenForReuse, this.abfsConfiguration);
    }

    @VisibleForTesting
    public AbfsRestOperation getAbfsRestOperation(AbfsRestOperationType operationType, String httpMethod, URL url, List<AbfsHttpHeader> requestHeaders) {
        return new AbfsRestOperation(operationType, this, httpMethod, url, requestHeaders, this.abfsConfiguration);
    }

    AbfsRestOperation getAbfsRestOperation(AbfsRestOperationType operationType, String httpMethod, URL url, List<AbfsHttpHeader> requestHeaders, String sasTokenForReuse) {
        return new AbfsRestOperation(operationType, this, httpMethod, url, requestHeaders, sasTokenForReuse, this.abfsConfiguration);
    }

    @VisibleForTesting
    AbfsApacheHttpClient getAbfsApacheHttpClient() {
        return this.abfsApacheHttpClient;
    }

    @VisibleForTesting
    KeepAliveCache getKeepAliveCache() {
        return this.keepAliveCache;
    }

    @VisibleForTesting
    protected Timer getTimer() {
        return this.timer;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    public static boolean getIsNamespaceEnabled() {
        return isNamespaceEnabled;
    }

    public static void setIsNamespaceEnabled(boolean namespaceEnabled) {
        isNamespaceEnabled = namespaceEnabled;
    }

    protected boolean isRenameResilience() {
        return this.renameResilience;
    }

    public abstract ListResponseData parseListPathResults(AbfsHttpOperation var1, URI var2) throws IOException;

    public abstract List<String> parseBlockListResponse(InputStream var1) throws IOException;

    public abstract StorageErrorResponseSchema processStorageErrorResponse(InputStream var1) throws IOException;

    public abstract Hashtable<String, String> getXMSProperties(AbfsHttpOperation var1) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException;

    public abstract byte[] encodeAttribute(String var1) throws UnsupportedEncodingException;

    public abstract String decodeAttribute(byte[] var1) throws UnsupportedEncodingException;

    protected AbfsRestOperation getSuccessOp(AbfsRestOperationType operationType, String httpMethod, URL url, List<AbfsHttpHeader> requestHeaders) {
        AbfsRestOperation successOp = this.getAbfsRestOperation(operationType, httpMethod, url, requestHeaders);
        successOp.hardSetResult(200);
        return successOp;
    }

    protected VersionedFileStatus getVersionedFileStatusFromEntry(ListResultEntrySchema entry, URI uri) throws AzureBlobFileSystemException {
        boolean isDirectory;
        long blockSize = this.abfsConfiguration.getAzureBlockSize();
        String owner = null;
        String group = null;
        try {
            if (this.identityTransformer != null) {
                owner = this.identityTransformer.transformIdentityForGetRequest(entry.owner(), true, this.userName);
                group = this.identityTransformer.transformIdentityForGetRequest(entry.group(), false, this.primaryUserGroup);
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to get owner/group for path {}", (Object)entry.name(), (Object)ex);
            throw new AbfsDriverException(ex);
        }
        String encryptionContext = entry.getXMsEncryptionContext();
        AbfsPermission fsPermission = entry.permissions() == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(entry.permissions());
        boolean hasAcl = AbfsPermission.isExtendedAcl(entry.permissions());
        long lastModifiedMillis = 0L;
        long contentLength = entry.contentLength() == null ? 0L : entry.contentLength();
        boolean bl = isDirectory = entry.isDirectory() != null && entry.isDirectory() != false;
        if (entry.lastModified() != null && !entry.lastModified().isEmpty()) {
            lastModifiedMillis = DateTimeUtils.parseLastModifiedTime(entry.lastModified());
        }
        Path entryPath = new Path(File.separator + entry.name());
        if (uri != null) {
            entryPath = entryPath.makeQualified(uri, entryPath);
        }
        return new VersionedFileStatus(owner, group, fsPermission, hasAcl, contentLength, isDirectory, 1, blockSize, lastModifiedMillis, entryPath, entry.eTag(), encryptionContext);
    }

    class TimerTaskImpl
    extends TimerTask {
        TimerTaskImpl() {
            AbfsClient.this.runningTimerTask = this;
        }

        @Override
        public void run() {
            block5: {
                try {
                    if (!AbfsClient.this.timerOrchestrator(TimerFunctionality.SUSPEND, this)) break block5;
                    try {
                        AbfsClient.this.getMetricCall(AbfsClient.this.getMetricTracingContext());
                    }
                    finally {
                        AbfsClient.this.abfsCounters.initializeMetrics(AbfsClient.this.metricFormat);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

