/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ExternalStoragePolicySatisfier {
    public static final Logger LOG = LoggerFactory.getLogger(ExternalStoragePolicySatisfier.class);

    private ExternalStoragePolicySatisfier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NameNodeConnector nnc = null;
        ExternalSPSContext context = null;
        try {
            StringUtils.startupShutdownMessage(StoragePolicySatisfier.class, (String[])args, (Logger)LOG);
            HdfsConfiguration spsConf = new HdfsConfiguration();
            ExternalStoragePolicySatisfier.secureLogin((Configuration)spsConf);
            StoragePolicySatisfier sps = new StoragePolicySatisfier((Configuration)spsConf);
            nnc = ExternalStoragePolicySatisfier.getNameNodeConnector((Configuration)spsConf);
            context = new ExternalSPSContext(sps, nnc);
            sps.init(context);
            sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
            context.initMetrics(sps);
            if (sps != null) {
                sps.join();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to start storage policy satisfier.", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        finally {
            if (nnc != null) {
                nnc.close();
            }
            if (context != null && context.getSpsBeanMetrics() != null) {
                context.closeMetrics();
            }
        }
    }

    private static void secureLogin(Configuration conf) throws IOException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        String addr = conf.get("dfs.storage.policy.satisfier.address", "0.0.0.0:0");
        InetSocketAddress socAddr = NetUtils.createSocketAddr((String)addr, (int)0, (String)"dfs.storage.policy.satisfier.address");
        SecurityUtil.login((Configuration)conf, (String)"dfs.storage.policy.satisfier.keytab.file", (String)"dfs.storage.policy.satisfier.kerberos.principal", (String)socAddr.getHostName());
    }

    public static NameNodeConnector getNameNodeConnector(Configuration conf) throws InterruptedException {
        Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
        Path externalSPSPathId = HdfsServerConstants.MOVER_ID_PATH;
        String serverName = ExternalStoragePolicySatisfier.class.getSimpleName();
        while (true) {
            try {
                List<NameNodeConnector> nncs = NameNodeConnector.newNameNodeConnectors(namenodes, serverName, externalSPSPathId, conf, 5);
                return nncs.get(0);
            }
            catch (IOException e) {
                LOG.warn("Failed to connect with namenode", (Throwable)e);
                if (e.getMessage().equals("Another " + serverName + " is running.")) {
                    ExitUtil.terminate((int)-1, (String)("Exit immediately because another " + serverName + " is running"));
                }
                Thread.sleep(3000L);
                continue;
            }
            break;
        }
    }
}

