/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TestIncrementsFromClientSide;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRegionIncrement {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionIncrement.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionIncrement.class);
    @Rule
    public TestName name = new TestName();
    private static HBaseTestingUtility TEST_UTIL;
    private static final byte[] INCREMENT_BYTES;
    private static final int THREAD_COUNT = 10;
    private static final int INCREMENT_COUNT = 10000;

    @Before
    public void setUp() throws Exception {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.cleanupTestDir();
    }

    private HRegion getRegion(Configuration conf, String tableName) throws IOException {
        FSHLog wal = new FSHLog(FileSystem.get((Configuration)conf), TEST_UTIL.getDataTestDir(), TEST_UTIL.getDataTestDir().toString(), conf);
        wal.init();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return TEST_UTIL.createLocalHRegion(Bytes.toBytes((String)tableName), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, tableName, conf, false, Durability.SKIP_WAL, (WAL)wal, (byte[][])new byte[][]{INCREMENT_BYTES});
    }

    private void closeRegion(HRegion region) throws IOException {
        region.close();
        region.getWAL().close();
    }

    @Test
    public void testMVCCCausingMisRead() throws IOException {
        HRegion region = this.getRegion(TEST_UTIL.getConfiguration(), this.name.getMethodName());
        this.closeRegion(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnContendedSingleCellIncrement() throws IOException, InterruptedException {
        HRegion region = this.getRegion(TEST_UTIL.getConfiguration(), TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        long startTime = System.currentTimeMillis();
        try {
            int i;
            SingleCellIncrementer[] threads = new SingleCellIncrementer[10];
            for (i = 0; i < threads.length; ++i) {
                byte[] rowBytes = Bytes.toBytes((int)i);
                Increment increment = new Increment(rowBytes);
                increment.addColumn(INCREMENT_BYTES, INCREMENT_BYTES, 1L);
                threads[i] = new SingleCellIncrementer(i, 10000, region, increment);
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            HRegion.RegionScannerImpl regionScanner = region.getScanner(new Scan());
            ArrayList cells = new ArrayList(10);
            while (regionScanner.next(cells)) {
            }
            Assert.assertEquals((long)10L, (long)cells.size());
            long total = 0L;
            for (Cell cell : cells) {
                total += Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
            }
            Assert.assertEquals((long)100000L, (long)total);
        }
        finally {
            this.closeRegion(region);
            LOG.info(this.name.getMethodName() + " " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContendedAcrossCellsIncrement() throws IOException, InterruptedException {
        HRegion region = this.getRegion(TEST_UTIL.getConfiguration(), TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        long startTime = System.currentTimeMillis();
        try {
            int i;
            CrossRowCellIncrementer[] threads = new CrossRowCellIncrementer[10];
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new CrossRowCellIncrementer(i, 10000, region, 10);
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            HRegion.RegionScannerImpl regionScanner = region.getScanner(new Scan());
            ArrayList cells = new ArrayList(100);
            while (regionScanner.next(cells)) {
            }
            Assert.assertEquals((long)10L, (long)cells.size());
            long total = 0L;
            for (Cell cell : cells) {
                total += Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
            }
            Assert.assertEquals((long)100000L, (long)total);
        }
        finally {
            this.closeRegion(region);
            LOG.info(this.name.getMethodName() + " " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    static {
        INCREMENT_BYTES = Bytes.toBytes((String)"increment");
    }

    private static class CrossRowCellIncrementer
    extends Thread {
        private final int count;
        private final HRegion region;
        private final Increment[] increments;

        CrossRowCellIncrementer(int i, int count, HRegion region, int range) {
            super("" + i);
            this.setDaemon(true);
            this.count = count;
            this.region = region;
            this.increments = new Increment[range];
            for (int ii = 0; ii < range; ++ii) {
                this.increments[ii] = new Increment(Bytes.toBytes((int)i));
                this.increments[ii].addColumn(INCREMENT_BYTES, INCREMENT_BYTES, 1L);
            }
        }

        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    int index = ThreadLocalRandom.current().nextInt(0, this.increments.length);
                    this.region.increment(this.increments[index]);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class SingleCellIncrementer
    extends Thread {
        private final int count;
        private final HRegion region;
        private final Increment increment;

        SingleCellIncrementer(int i, int count, HRegion region, Increment increment) {
            super("" + i);
            this.setDaemon(true);
            this.count = count;
            this.region = region;
            this.increment = increment;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    this.region.increment(this.increment);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

