/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.rest.protobuf.generated.TableListMessage;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="TableList")
@InterfaceAudience.Private
public class TableListModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    private List<TableModel> tables = new ArrayList<TableModel>();

    public void add(TableModel table) {
        this.tables.add(table);
    }

    public TableModel get(int index) {
        return this.tables.get(index);
    }

    @XmlElementRef(name="table")
    public List<TableModel> getTables() {
        return this.tables;
    }

    public void setTables(List<TableModel> tables) {
        this.tables = tables;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TableModel aTable : this.tables) {
            sb.append(aTable.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public byte[] createProtobufOutput() {
        TableListMessage.TableList.Builder builder = TableListMessage.TableList.newBuilder();
        for (TableModel aTable : this.tables) {
            builder.addName(aTable.getName());
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        TableListMessage.TableList.Builder builder = TableListMessage.TableList.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])message);
        for (String table : builder.getNameList()) {
            this.add(new TableModel(table));
        }
        return this;
    }
}

