/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.extended;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.CountOperation;
import org.terracotta.statistics.extended.Latency;
import org.terracotta.statistics.extended.Result;
import org.terracotta.statistics.extended.SampledStatistic;
import org.terracotta.statistics.extended.StatisticType;

public final class NullCompoundOperation<T extends Enum<T>>
implements CompoundOperation<T> {
    private static final CompoundOperation INSTANCE = new NullCompoundOperation();

    private NullCompoundOperation() {
    }

    public static <T extends Enum<T>> CompoundOperation<T> instance(Class<T> klazz) {
        return INSTANCE;
    }

    @Override
    public Class<T> type() {
        return null;
    }

    @Override
    public Result component(T result) {
        return NullOperation.instance();
    }

    @Override
    public Result compound(EnumSet<T> results) {
        return NullOperation.instance();
    }

    @Override
    public CountOperation<T> asCountOperation() {
        return new CountOperation<T>(){

            @Override
            public long value(T result) {
                return -1L;
            }

            @Override
            public long value(T ... results) {
                return -1L;
            }
        };
    }

    @Override
    public SampledStatistic<Double> ratioOf(EnumSet<T> numerator, EnumSet<T> denominator) {
        return NullSampledStatistic.instance(StatisticType.RATIO);
    }

    @Override
    public boolean expire(long expiry) {
        return false;
    }

    @Override
    public void setAlwaysOn(boolean enable) {
    }

    @Override
    public void setWindow(long time, TimeUnit unit) {
    }

    @Override
    public void setHistory(int samples, long time, TimeUnit unit) {
    }

    @Override
    public boolean isAlwaysOn() {
        return false;
    }

    @Override
    public long getWindowSize(TimeUnit unit) {
        return 0L;
    }

    @Override
    public int getHistorySampleSize() {
        return 0;
    }

    @Override
    public long getHistorySampleTime(TimeUnit unit) {
        return 0L;
    }

    static final class NullSampledStatistic<T extends Number>
    implements SampledStatistic<T> {
        private static final Map<StatisticType, SampledStatistic<?>> COMMON = new HashMap();
        private final T value;
        private final StatisticType type;

        private NullSampledStatistic(T value, StatisticType type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public boolean active() {
            return false;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public StatisticType type() {
            return this.type;
        }

        @Override
        public List<Timestamped<T>> history() throws UnsupportedOperationException {
            return Collections.emptyList();
        }

        @Override
        public List<Timestamped<T>> history(long since) {
            return Collections.emptyList();
        }

        static <T extends Number> SampledStatistic<T> instance(StatisticType type) {
            if (type == null) {
                throw new NullPointerException();
            }
            return COMMON.get((Object)type);
        }

        static {
            COMMON.put(StatisticType.COUNTER, new NullSampledStatistic<Long>(0L, StatisticType.COUNTER));
            COMMON.put(StatisticType.RATE, new NullSampledStatistic<Double>(Double.NaN, StatisticType.RATE));
            COMMON.put(StatisticType.LATENCY_MIN, new NullSampledStatistic<Object>(null, StatisticType.LATENCY_MIN));
            COMMON.put(StatisticType.LATENCY_MAX, new NullSampledStatistic<Object>(null, StatisticType.LATENCY_MAX));
            COMMON.put(StatisticType.LATENCY_AVG, new NullSampledStatistic<Double>(Double.NaN, StatisticType.LATENCY_AVG));
            COMMON.put(StatisticType.RATIO, new NullSampledStatistic<Double>(Double.NaN, StatisticType.RATIO));
            COMMON.put(StatisticType.SIZE, new NullSampledStatistic<Long>(0L, StatisticType.SIZE));
        }
    }

    static final class NullLatency
    implements Latency {
        private static final Latency INSTANCE = new NullLatency();

        private NullLatency() {
        }

        static Latency instance() {
            return INSTANCE;
        }

        @Override
        public SampledStatistic<Long> minimum() {
            return NullSampledStatistic.instance(StatisticType.LATENCY_MIN);
        }

        @Override
        public SampledStatistic<Long> maximum() {
            return NullSampledStatistic.instance(StatisticType.LATENCY_MAX);
        }

        @Override
        public SampledStatistic<Double> average() {
            return NullSampledStatistic.instance(StatisticType.LATENCY_AVG);
        }
    }

    static final class NullOperation
    implements Result {
        private static final Result INSTANCE = new NullOperation();

        private NullOperation() {
        }

        static final Result instance() {
            return INSTANCE;
        }

        @Override
        public SampledStatistic<Long> count() {
            return NullSampledStatistic.instance(StatisticType.COUNTER);
        }

        @Override
        public SampledStatistic<Double> rate() {
            return NullSampledStatistic.instance(StatisticType.RATE);
        }

        @Override
        public Latency latency() throws UnsupportedOperationException {
            return NullLatency.instance();
        }
    }
}

