/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class RSGroupProtobufUtil {
    private RSGroupProtobufUtil() {
    }

    static void populateBalanceRSGroupResponse(RSGroupAdminProtos.BalanceRSGroupResponse.Builder responseBuilder, BalanceResponse response) {
        responseBuilder.setBalanceRan(response.isBalancerRan()).setMovesCalculated(response.getMovesCalculated()).setMovesExecuted(response.getMovesExecuted());
    }

    static BalanceResponse toBalanceResponse(RSGroupAdminProtos.BalanceRSGroupResponse response) {
        return BalanceResponse.newBuilder().setBalancerRan(response.getBalanceRan()).setMovesExecuted(response.hasMovesExecuted() ? response.getMovesExecuted() : 0).setMovesCalculated(response.hasMovesCalculated() ? response.getMovesCalculated() : 0).build();
    }

    static RSGroupAdminProtos.BalanceRSGroupRequest createBalanceRSGroupRequest(String groupName, BalanceRequest request) {
        return RSGroupAdminProtos.BalanceRSGroupRequest.newBuilder().setRSGroupName(groupName).setDryRun(request.isDryRun()).setIgnoreRit(request.isIgnoreRegionsInTransition()).build();
    }

    static BalanceRequest toBalanceRequest(RSGroupAdminProtos.BalanceRSGroupRequest request) {
        return BalanceRequest.newBuilder().setDryRun(request.hasDryRun() && request.getDryRun()).setIgnoreRegionsInTransition(request.hasIgnoreRit() && request.getIgnoreRit()).build();
    }

    static RSGroupInfo toGroupInfo(RSGroupProtos.RSGroupInfo proto) {
        RSGroupInfo rsGroupInfo = new RSGroupInfo(proto.getName());
        for (HBaseProtos.ServerName el : proto.getServersList()) {
            rsGroupInfo.addServer(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        for (TableProtos.TableName pTableName : proto.getTablesList()) {
            rsGroupInfo.addTable(ProtobufUtil.toTableName((TableProtos.TableName)pTableName));
        }
        proto.getConfigurationList().forEach(pair -> rsGroupInfo.setConfiguration(pair.getName(), pair.getValue()));
        return rsGroupInfo;
    }

    static RSGroupProtos.RSGroupInfo toProtoGroupInfo(RSGroupInfo pojo) {
        ArrayList<TableProtos.TableName> tables = new ArrayList<TableProtos.TableName>(pojo.getTables().size());
        for (Object arg : pojo.getTables()) {
            tables.add(ProtobufUtil.toProtoTableName((TableName)arg));
        }
        ArrayList<HBaseProtos.ServerName> hostports = new ArrayList<HBaseProtos.ServerName>(pojo.getServers().size());
        for (Address el : pojo.getServers()) {
            hostports.add(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        List configuration = pojo.getConfiguration().entrySet().stream().map(entry -> HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build()).collect(Collectors.toList());
        return RSGroupProtos.RSGroupInfo.newBuilder().setName(pojo.getName()).addAllServers(hostports).addAllTables(tables).addAllConfiguration(configuration).build();
    }
}

