/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import java.io.StringReader;
import java.text.ParseException;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.parsers.ParserMonitor;
import org.apache.directory.api.ldap.model.schema.parsers.ParserMonitorAdapter;
import org.apache.directory.api.ldap.model.schema.parsers.ReusableAntlrSchemaLexer;
import org.apache.directory.api.ldap.model.schema.parsers.ReusableAntlrSchemaParser;
import org.apache.directory.api.util.Strings;

public abstract class AbstractSchemaParser {
    protected ParserMonitor monitor = new ParserMonitorAdapter();
    protected ReusableAntlrSchemaParser parser;
    protected ReusableAntlrSchemaLexer lexer = new ReusableAntlrSchemaLexer(new StringReader(""));

    protected AbstractSchemaParser() {
        this.parser = new ReusableAntlrSchemaParser(this.lexer);
    }

    protected void reset(String spec) {
        StringReader in = new StringReader(spec);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public void setParserMonitor(ParserMonitor parserMonitor) {
        this.monitor = parserMonitor;
        this.parser.setParserMonitor(parserMonitor);
    }

    public void setQuirksMode(boolean enabled) {
        this.parser.setQuirksMode(enabled);
    }

    public boolean isQuirksMode() {
        return this.parser.isQuirksMode();
    }

    public abstract SchemaObject parse(String var1) throws ParseException;

    protected static void updateSchemaName(SchemaObject schemaObject) {
        List<String> schemaExtension = schemaObject.getExtensions().get("X-SCHEMA");
        if (schemaExtension != null) {
            String schemaName = schemaExtension.get(0);
            if (Strings.isEmpty((String)schemaName)) {
                schemaObject.setSchemaName("other");
            } else {
                schemaObject.setSchemaName(schemaName);
            }
        } else {
            schemaObject.setSchemaName("other");
        }
    }
}

