/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import javax.transaction.xa.Xid;
import net.sf.ehcache.transaction.xa.XidTransactionID;

public class XidTransactionIDImpl
implements XidTransactionID {
    private final Xid xid;
    private volatile Decision decision = Decision.IN_DOUBT;

    public XidTransactionIDImpl(Xid xid) {
        this.xid = xid;
    }

    public boolean isDecisionCommit() {
        return this.decision.equals((Object)Decision.COMMIT);
    }

    public void markForCommit() {
        if (this.decision.equals((Object)Decision.ROLLBACK)) {
            throw new IllegalStateException(this + " already marked for rollback, cannot re-mark it for commit");
        }
        this.decision = Decision.COMMIT;
    }

    public boolean isDecisionRollback() {
        return this.decision.equals((Object)Decision.ROLLBACK);
    }

    public void markForRollback() {
        if (this.decision.equals((Object)Decision.COMMIT)) {
            throw new IllegalStateException(this + " already marked for commit, cannot re-mark it for rollback");
        }
        this.decision = Decision.ROLLBACK;
    }

    public Xid getXid() {
        return this.xid;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof XidTransactionIDImpl) {
            XidTransactionIDImpl otherId = (XidTransactionIDImpl)obj;
            return this.xid.equals(otherId.xid);
        }
        return false;
    }

    public final int hashCode() {
        return this.xid.hashCode();
    }

    public String toString() {
        return "Unclustered " + this.xid + " (decision: " + (Object)((Object)this.decision) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Decision {
        IN_DOUBT,
        COMMIT,
        ROLLBACK;

    }
}

