/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.ByteBuffDecompressionCodec;
import org.apache.hadoop.hbase.io.compress.ByteBuffDecompressor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.DictionaryCache;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdByteBuffDecompressor;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCompressor;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdDecompressor;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdHFileDecompressionContext;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZstdCodec
implements Configurable,
CompressionCodec,
ByteBuffDecompressionCodec {
    public static final String ZSTD_LEVEL_KEY = "hbase.io.compress.zstd.level";
    public static final String ZSTD_BUFFER_SIZE_KEY = "hbase.io.compress.zstd.buffersize";
    public static final int ZSTD_BUFFER_SIZE_DEFAULT = 262144;
    public static final String ZSTD_DICTIONARY_KEY = "hbase.io.compress.zstd.dictionary";
    private static final Cache<String, Pair<ZstdDictDecompress, Integer>> DECOMPRESS_DICT_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private Configuration conf = new Configuration();
    private int bufferSize;
    private int level;
    private byte[] dictionary;

    public ZstdCodec() {
        this.init();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.init();
    }

    public Compressor createCompressor() {
        return new ZstdCompressor(this.level, this.bufferSize, this.dictionary);
    }

    public Decompressor createDecompressor() {
        return new ZstdDecompressor(this.bufferSize, this.dictionary);
    }

    public ByteBuffDecompressor createByteBuffDecompressor() {
        return new ZstdByteBuffDecompressor(this.dictionary);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, (int)Zstd.compressBound((long)this.bufferSize) - this.bufferSize);
    }

    public Class<? extends Compressor> getCompressorType() {
        return ZstdCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return ZstdDecompressor.class;
    }

    public Class<? extends ByteBuffDecompressor> getByteBuffDecompressorType() {
        return ZstdByteBuffDecompressor.class;
    }

    public Compression.HFileDecompressionContext getDecompressionContextFromConfiguration(Configuration conf) {
        return ZstdHFileDecompressionContext.fromConfiguration(conf);
    }

    public String getDefaultExtension() {
        return ".zst";
    }

    static int getLevel(Configuration conf) {
        return conf.getInt(ZSTD_LEVEL_KEY, conf.getInt("io.compression.codec.zstd.level", 3));
    }

    static int getBufferSize(Configuration conf) {
        int size = conf.getInt(ZSTD_BUFFER_SIZE_KEY, conf.getInt("io.compression.codec.zstd.buffersize", 0));
        return size > 0 ? size : 262144;
    }

    @Nullable
    static byte[] getDictionary(Configuration conf) {
        String path = conf.get(ZSTD_DICTIONARY_KEY);
        return DictionaryCache.getDictionary((Configuration)conf, (String)path);
    }

    @Nullable
    static Pair<ZstdDictDecompress, Integer> getDecompressDictionary(Configuration conf) {
        String path = conf.get(ZSTD_DICTIONARY_KEY);
        if (path == null) {
            return null;
        }
        try {
            return (Pair)DECOMPRESS_DICT_CACHE.get((Object)path, () -> {
                byte[] dictBytes = DictionaryCache.getDictionary((Configuration)conf, (String)path);
                int dictId = ZstdCodec.getDictionaryId(dictBytes);
                return new Pair((Object)new ZstdDictDecompress(dictBytes), (Object)dictId);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to load ZSTD dictionary", e);
        }
    }

    static boolean isDictionary(byte[] dictionary) {
        return dictionary[0] == 55 && dictionary[1] == -92 && dictionary[2] == 48 && dictionary[3] == -20;
    }

    static int getDictionaryId(byte[] dictionary) {
        if (!ZstdCodec.isDictionary(dictionary)) {
            throw new IllegalArgumentException("Not a ZStandard dictionary");
        }
        return ByteBuffer.wrap(dictionary, 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private void init() {
        this.bufferSize = ZstdCodec.getBufferSize(this.conf);
        this.level = ZstdCodec.getLevel(this.conf);
        this.dictionary = ZstdCodec.getDictionary(this.conf);
    }
}

