/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.RevisionName;
import org.apache.directory.mavibot.btree.RevisionNameComparator;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.ByteArraySerializer;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.mavibot.btree.util.Strings;

public class RevisionNameSerializer
extends AbstractElementSerializer<RevisionName> {
    public RevisionNameSerializer() {
        super(new RevisionNameComparator());
    }

    public static RevisionName deserialize(byte[] in) {
        return RevisionNameSerializer.deserialize(in, 0);
    }

    public static RevisionName deserialize(byte[] in, int start) {
        if (in == null || in.length < 12 + start) {
            throw new RuntimeException("Cannot extract a RevisionName from a buffer with not enough bytes");
        }
        long revision = LongSerializer.deserialize(in, start);
        String name = StringSerializer.deserialize(in, 8 + start);
        RevisionName revisionName = new RevisionName(revision, name);
        return revisionName;
    }

    @Override
    public byte[] serialize(RevisionName revisionName) {
        if (revisionName == null) {
            throw new RuntimeException("The revisionName instance should not be null ");
        }
        byte[] result = null;
        if (revisionName.getName() != null) {
            byte[] stringBytes = Strings.getBytesUtf8(revisionName.getName());
            int stringLen = stringBytes.length;
            result = new byte[12 + stringBytes.length];
            LongSerializer.serialize(result, 0, revisionName.getRevision());
            if (stringLen > 0) {
                ByteArraySerializer.serialize(result, 8, stringBytes);
            }
        } else {
            result = new byte[12];
            LongSerializer.serialize(result, 0, revisionName.getRevision());
            StringSerializer.serialize(result, 8, null);
        }
        return result;
    }

    public static byte[] serialize(byte[] buffer, int start, RevisionName revisionName) {
        if (revisionName.getName() != null) {
            byte[] stringBytes = Strings.getBytesUtf8(revisionName.getName());
            int stringLen = stringBytes.length;
            LongSerializer.serialize(buffer, start, revisionName.getRevision());
            IntSerializer.serialize(buffer, 8 + start, stringLen);
            ByteArraySerializer.serialize(buffer, 12 + start, stringBytes);
        } else {
            LongSerializer.serialize(buffer, start, revisionName.getRevision());
            StringSerializer.serialize(buffer, 8, null);
        }
        return buffer;
    }

    @Override
    public RevisionName deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] revisionBytes = bufferHandler.read(8);
        long revision = LongSerializer.deserialize(revisionBytes);
        byte[] lengthBytes = bufferHandler.read(4);
        int len = IntSerializer.deserialize(lengthBytes);
        switch (len) {
            case 0: {
                return new RevisionName(revision, "");
            }
            case -1: {
                return new RevisionName(revision, null);
            }
        }
        byte[] nameBytes = bufferHandler.read(len);
        return new RevisionName(revision, Strings.utf8ToString(nameBytes));
    }

    @Override
    public RevisionName deserialize(ByteBuffer buffer) throws IOException {
        long revision = buffer.getLong();
        int len = buffer.getInt();
        switch (len) {
            case 0: {
                return new RevisionName(revision, "");
            }
            case -1: {
                return new RevisionName(revision, null);
            }
        }
        byte[] nameBytes = new byte[len];
        buffer.get(nameBytes);
        return new RevisionName(revision, Strings.utf8ToString(nameBytes));
    }
}

