/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRestartWithEmptyWALDirectory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRestartWithEmptyWALDirectory.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"test");
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        UTIL.startMiniCluster(1);
        UTIL.createTable(NAME, FAMILY).close();
        UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRestart() throws IOException, InterruptedException {
        byte[] row = Bytes.toBytes((int)0);
        try (Table table = UTIL.getConnection().getTable(NAME);){
            table.put(new Put(row).addColumn(FAMILY, QUALIFIER, row));
        }
        UTIL.flush(TableName.META_TABLE_NAME);
        UTIL.flush(NAME);
        UTIL.getMiniHBaseCluster().stopMaster(0).join();
        UTIL.getMiniHBaseCluster().stopRegionServer(0).join();
        UTIL.getTestFileSystem().delete(new Path(CommonFSUtils.getWALRootDir((Configuration)UTIL.getConfiguration()), "WALs"), true);
        UTIL.getMiniHBaseCluster().startMaster();
        UTIL.getMiniHBaseCluster().startRegionServer();
        UTIL.waitTableAvailable(NAME);
        table = UTIL.getConnection().getTable(NAME);
        var3_3 = null;
        try {
            Assert.assertArrayEquals((byte[])row, (byte[])table.get(new Get(row)).getValue(FAMILY, QUALIFIER));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var3_3 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
    }
}

