/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterQuotasObserver;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMasterQuotasObserverWithMocks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterQuotasObserverWithMocks.class);
    private HMaster master;
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = HBaseConfiguration.create();
        this.master = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doCallRealMethod().when((Object)this.master)).updateConfigurationForQuotasObserver((Configuration)ArgumentMatchers.any());
    }

    @Test
    public void testAddDefaultObserver() {
        this.master.updateConfigurationForQuotasObserver(this.conf);
        Assert.assertEquals((Object)MasterQuotasObserver.class.getName(), (Object)this.conf.get("hbase.coprocessor.master.classes"));
    }

    @Test
    public void testDoNotAddDefaultObserver() {
        this.conf.setBoolean("hbase.quota.remove.on.table.delete", false);
        this.master.updateConfigurationForQuotasObserver(this.conf);
        Assert.assertNull((Object)this.conf.getStrings("hbase.coprocessor.master.classes"));
    }

    @Test
    public void testAppendsObserver() {
        this.conf.set("hbase.coprocessor.master.classes", AccessController.class.getName());
        this.master.updateConfigurationForQuotasObserver(this.conf);
        HashSet coprocs = new HashSet(this.conf.getStringCollection("hbase.coprocessor.master.classes"));
        Assert.assertEquals((long)2L, (long)coprocs.size());
        Assert.assertTrue((String)("Observed coprocessors were: " + coprocs), (boolean)coprocs.contains(AccessController.class.getName()));
        Assert.assertTrue((String)("Observed coprocessors were: " + coprocs), (boolean)coprocs.contains(MasterQuotasObserver.class.getName()));
    }
}

