/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class MobSnapshotTestingUtils {
    public static void createMobTable(HBaseTestingUtility util, TableName tableName, int regionReplication, byte[] ... families) throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(util, tableName, SnapshotTestingUtils.getSplitKeys(), regionReplication, StoreFileTrackerFactory.Trackers.DEFAULT.name(), families);
    }

    public static void createMobTable(HBaseTestingUtility util, TableName tableName, int regionReplication, String storeFileTracker, byte[] ... families) throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(util, tableName, SnapshotTestingUtils.getSplitKeys(), regionReplication, storeFileTracker, families);
    }

    public static void createPreSplitMobTable(HBaseTestingUtility util, TableName tableName, int nRegions, byte[] ... families) throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(util, tableName, SnapshotTestingUtils.getSplitKeys(nRegions), 1, families);
    }

    public static void createMobTable(HBaseTestingUtility util, TableName tableName, byte[][] splitKeys, int regionReplication, byte[] ... families) throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(util, tableName, splitKeys, regionReplication, StoreFileTrackerFactory.Trackers.DEFAULT.name(), families);
    }

    public static void createMobTable(HBaseTestingUtility util, TableName tableName, byte[][] splitKeys, int regionReplication, String storeFileTracker, byte[] ... families) throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(util, tableName, splitKeys, regionReplication, storeFileTracker, null, families);
    }

    public static void createMobTable(HBaseTestingUtility util, TableName tableName, byte[][] splitKeys, int regionReplication, String storeFileTracker, String cpClassName, byte[] ... families) throws IOException, InterruptedException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(regionReplication);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMobEnabled(true).setMobThreshold(0L).build());
        }
        if (!StringUtils.isBlank((CharSequence)cpClassName)) {
            builder.setCoprocessor(cpClassName);
        }
        builder.setValue("hbase.store.file-tracker.impl", storeFileTracker);
        util.getAdmin().createTable(builder.build(), splitKeys);
        SnapshotTestingUtils.waitForTableToBeOnline(util, tableName);
        Assert.assertEquals((long)((splitKeys.length + 1) * regionReplication), (long)util.getAdmin().getRegions(tableName).size());
    }

    public static Table createMobTable(HBaseTestingUtility util, TableName tableName, byte[] ... families) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setBloomFilterType(BloomType.NONE).setMobEnabled(true).setMobThreshold(0L).build());
        }
        util.getAdmin().createTable(builder.build());
        util.waitUntilAllRegionsAssigned(tableName);
        return ConnectionFactory.createConnection((Configuration)util.getConfiguration()).getTable(tableName);
    }

    public static int countMobRows(Table table, byte[] ... families) throws IOException {
        Scan scan = new Scan();
        for (byte[] family : families) {
            scan.addFamily(family);
        }
        try (ResultScanner results = table.getScanner(scan);){
            Result res;
            int count = 0;
            while ((res = results.next()) != null) {
                ++count;
                for (Cell cell : res.listCells()) {
                    Assert.assertTrue((CellUtil.cloneValue((Cell)cell).length > 0 ? 1 : 0) != 0);
                }
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyMobRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        try (Table table = ConnectionFactory.createConnection((Configuration)util.getConfiguration()).getTable(tableName);){
            Assert.assertEquals((long)expectedRows, (long)MobSnapshotTestingUtils.countMobRows(table, new byte[0][]));
        }
    }

    public static class SnapshotMock
    extends SnapshotTestingUtils.SnapshotMock {
        public SnapshotMock(Configuration conf, FileSystem fs, Path rootDir) {
            super(conf, fs, rootDir);
        }

        @Override
        public TableDescriptor createHtd(String tableName) {
            return TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf")).setMobEnabled(true).setMobThreshold(0L).build()).build();
        }
    }
}

