/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.provider.consumer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hbase.thirdparty.javax.ws.rs.Consumes;
import org.apache.hbase.thirdparty.javax.ws.rs.WebApplicationException;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MultivaluedMap;
import org.apache.hbase.thirdparty.javax.ws.rs.ext.MessageBodyReader;
import org.apache.hbase.thirdparty.javax.ws.rs.ext.Provider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/x-protobuf", "application/protobuf"})
@InterfaceAudience.Private
public class ProtobufMessageBodyConsumer
implements MessageBodyReader<ProtobufMessageHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufMessageBodyConsumer.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ProtobufMessageHandler.class.isAssignableFrom(type);
    }

    public ProtobufMessageHandler readFrom(Class<ProtobufMessageHandler> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException, WebApplicationException {
        ProtobufMessageHandler obj = null;
        try {
            obj = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj.getObjectFromMessage(inputStream);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

