/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.NamespacesInstanceModel;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.javax.ws.rs.Consumes;
import org.apache.hbase.thirdparty.javax.ws.rs.DELETE;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.POST;
import org.apache.hbase.thirdparty.javax.ws.rs.PUT;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.hbase.thirdparty.javax.ws.rs.core.HttpHeaders;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NamespacesInstanceResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(NamespacesInstanceResource.class);
    String namespace;
    boolean queryTables = false;

    public NamespacesInstanceResource(String namespace) throws IOException {
        this(namespace, false);
    }

    public NamespacesInstanceResource(String namespace, boolean queryTables) throws IOException {
        this.namespace = namespace;
        this.queryTables = queryTables;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context ServletContext context, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.queryTables) {
            TableListModel tableModel = new TableListModel();
            try {
                List tables = this.servlet.getAdmin().listTableDescriptorsByNamespace(Bytes.toBytes((String)this.namespace));
                for (TableDescriptor table : tables) {
                    tableModel.add(new TableModel(table.getTableName().getQualifierAsString()));
                }
                this.servlet.getMetrics().incrementSucessfulGetRequests(1);
                return Response.ok((Object)tableModel).build();
            }
            catch (IOException e) {
                this.servlet.getMetrics().incrementFailedGetRequests(1);
                throw new RuntimeException("Cannot retrieve table list for '" + this.namespace + "'.");
            }
        }
        try {
            NamespacesInstanceModel rowModel = new NamespacesInstanceModel(this.servlet.getAdmin(), this.namespace);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)rowModel).build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new RuntimeException("Cannot retrieve info for '" + this.namespace + "'.");
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response put(NamespacesInstanceModel model, @Context UriInfo uriInfo) {
        return this.processUpdate(model, true, uriInfo);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response post(NamespacesInstanceModel model, @Context UriInfo uriInfo) {
        return this.processUpdate(model, false, uriInfo);
    }

    private Response processUpdate(NamespacesInstanceModel model, boolean updateExisting, UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((updateExisting ? "PUT " : "POST ") + uriInfo.getAbsolutePath());
        }
        if (model == null) {
            try {
                model = new NamespacesInstanceModel(this.namespace);
            }
            catch (IOException ioe) {
                this.servlet.getMetrics().incrementFailedPutRequests(1);
                throw new RuntimeException("Cannot retrieve info for '" + this.namespace + "'.");
            }
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        Admin admin = null;
        boolean namespaceExists = false;
        try {
            admin = this.servlet.getAdmin();
            namespaceExists = this.doesNamespaceExist(admin, this.namespace);
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return this.processException(e);
        }
        if (!updateExisting && namespaceExists) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)("Namespace '" + this.namespace + "' already exists.  Use REST PUT to alter the existing namespace.")).build();
        }
        if (updateExisting && !namespaceExists) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)("Namespace '" + this.namespace + "' does not exist. Use REST POST to create the namespace.")).build();
        }
        return this.createOrUpdate(model, uriInfo, admin, updateExisting);
    }

    private Response createOrUpdate(NamespacesInstanceModel model, UriInfo uriInfo, Admin admin, boolean updateExisting) {
        NamespaceDescriptor.Builder builder = NamespaceDescriptor.create((String)this.namespace);
        builder.addConfiguration(model.getProperties());
        if (model.getProperties().size() > 0) {
            builder.addConfiguration(model.getProperties());
        }
        NamespaceDescriptor nsd = builder.build();
        try {
            if (updateExisting) {
                admin.modifyNamespace(nsd);
            } else {
                admin.createNamespace(nsd);
            }
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return this.processException(e);
        }
        this.servlet.getMetrics().incrementSucessfulPutRequests(1);
        return updateExisting ? Response.ok((Object)uriInfo.getAbsolutePath()).build() : Response.created((URI)uriInfo.getAbsolutePath()).build();
    }

    private boolean doesNamespaceExist(Admin admin, String namespaceName) throws IOException {
        NamespaceDescriptor[] nd = admin.listNamespaceDescriptors();
        for (int i = 0; i < nd.length; ++i) {
            if (!nd[i].getName().equals(namespaceName)) continue;
            return true;
        }
        return false;
    }

    @DELETE
    public Response deleteNoBody(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("DELETE " + uriInfo.getAbsolutePath());
        }
        if (this.servlet.isReadOnly()) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        try {
            Admin admin = this.servlet.getAdmin();
            if (!this.doesNamespaceExist(admin, this.namespace)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Namespace '" + this.namespace + "' does not exists.  Cannot drop namespace.")).build();
            }
            admin.deleteNamespace(this.namespace);
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            return Response.ok().build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            return this.processException(e);
        }
    }

    @Path(value="tables")
    public NamespacesInstanceResource getNamespaceInstanceResource(@PathParam(value="tables") String namespace) throws IOException {
        return new NamespacesInstanceResource(this.namespace, true);
    }
}

