/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.javax.ws.rs.WebApplicationException;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ResourceBase
implements Constants {
    RESTServlet servlet = RESTServlet.getInstance();
    Class<?> accessDeniedClazz;

    public ResourceBase() throws IOException {
        try {
            this.accessDeniedClazz = Class.forName("org.apache.hadoop.hbase.security.AccessDeniedException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected Response processException(Throwable exp) {
        if (this.accessDeniedClazz != null) {
            for (Throwable curr = exp; curr != null; curr = curr.getCause()) {
                if (!this.accessDeniedClazz.isAssignableFrom(curr.getClass())) continue;
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)("Forbidden\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
            }
        }
        if (exp instanceof TableNotFoundException || exp.getCause() instanceof TableNotFoundException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Not found\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
        }
        if (exp instanceof NoSuchColumnFamilyException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Not found\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
        }
        if (exp instanceof RuntimeException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("Bad request\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
        }
        if (exp instanceof RetriesExhaustedException) {
            RetriesExhaustedException retryException = (RetriesExhaustedException)exp;
            this.processException(retryException.getCause());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)("Unavailable\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
    }
}

