/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MultiThreadedClientExample
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MultiThreadedClientExample.class);
    private static final int DEFAULT_NUM_OPERATIONS = 500000;
    private static final byte[] FAMILY = Bytes.toBytes((String)"d");
    private static final byte[] QUAL = Bytes.toBytes((String)"test");
    private final ExecutorService internalPool;
    private final int threads = Runtime.getRuntime().availableProcessors() * 4;

    public MultiThreadedClientExample() throws IOException {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("internal-pol-%d").build();
        this.internalPool = Executors.newFixedThreadPool(this.threads, threadFactory);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: " + ((Object)((Object)this)).getClass().getName() + " tableName [num_operations]");
            return -1;
        }
        TableName tableName = TableName.valueOf((String)args[0]);
        int numOperations = 500000;
        if (args.length == 2) {
            numOperations = Integer.parseInt(args[1]);
        }
        ThreadPoolExecutor service = new ThreadPoolExecutor(this.threads * 2, this.threads * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Connection writeConnection = ConnectionFactory.createConnection((Configuration)this.getConf(), (ExecutorService)service);
        Connection readConnection = ConnectionFactory.createConnection((Configuration)this.getConf(), (ExecutorService)service);
        this.warmUpConnectionCache(readConnection, tableName);
        this.warmUpConnectionCache(writeConnection, tableName);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(numOperations);
        for (int i = 0; i < numOperations; ++i) {
            double d = ThreadLocalRandom.current().nextDouble();
            Future<Boolean> f = d < 0.3 ? this.internalPool.submit(new WriteExampleCallable(writeConnection, tableName)) : (d < 0.5 ? this.internalPool.submit(new SingleWriteExampleCallable(writeConnection, tableName)) : this.internalPool.submit(new ReadExampleCallable(writeConnection, tableName)));
            futures.add(f);
        }
        for (Future future : futures) {
            future.get(10L, TimeUnit.MINUTES);
        }
        this.internalPool.shutdownNow();
        service.shutdownNow();
        return 0;
    }

    private void warmUpConnectionCache(Connection connection, TableName tn) throws IOException {
        try (RegionLocator locator = connection.getRegionLocator(tn);){
            LOG.info("Warmed up region location cache for " + tn + " got " + locator.getAllRegionLocations().size());
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new MultiThreadedClientExample(), (String[])args);
    }

    public static class ReadExampleCallable
    implements Callable<Boolean> {
        private final Connection connection;
        private final TableName tableName;

        public ReadExampleCallable(Connection connection, TableName tableName) {
            this.connection = connection;
            this.tableName = tableName;
        }

        @Override
        public Boolean call() throws Exception {
            int result = 0;
            int toRead = 100;
            try (Table t = this.connection.getTable(this.tableName);){
                byte[] rk = Bytes.toBytes((long)ThreadLocalRandom.current().nextLong());
                Scan s = new Scan().withStartRow(rk);
                s.setFilter((Filter)new KeyOnlyFilter());
                s.setCaching(20);
                s.setCacheBlocks(false);
                try (ResultScanner rs = t.getScanner(s);){
                    for (Result r : rs) {
                        result += r.getRow().length;
                        if (--toRead > 0) continue;
                        break;
                    }
                }
            }
            return result > 0;
        }
    }

    public static class SingleWriteExampleCallable
    implements Callable<Boolean> {
        private final Connection connection;
        private final TableName tableName;

        public SingleWriteExampleCallable(Connection connection, TableName tableName) {
            this.connection = connection;
            this.tableName = tableName;
        }

        @Override
        public Boolean call() throws Exception {
            try (Table t = this.connection.getTable(this.tableName);){
                byte[] value = Bytes.toBytes((String)Double.toString(ThreadLocalRandom.current().nextDouble()));
                byte[] rk = Bytes.toBytes((long)ThreadLocalRandom.current().nextLong());
                Put p = new Put(rk);
                p.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(rk).setFamily(FAMILY).setQualifier(QUAL).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(value).build());
                t.put(p);
            }
            return true;
        }
    }

    public static class WriteExampleCallable
    implements Callable<Boolean> {
        private final Connection connection;
        private final TableName tableName;

        public WriteExampleCallable(Connection connection, TableName tableName) {
            this.connection = connection;
            this.tableName = tableName;
        }

        @Override
        public Boolean call() throws Exception {
            try (Table t = this.connection.getTable(this.tableName);){
                byte[] value = Bytes.toBytes((String)Double.toString(ThreadLocalRandom.current().nextDouble()));
                int rows = 30;
                ArrayList<Put> puts = new ArrayList<Put>(rows);
                for (int i = 0; i < 30; ++i) {
                    byte[] rk = Bytes.toBytes((long)ThreadLocalRandom.current().nextLong());
                    Put p = new Put(rk);
                    p.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(rk).setFamily(FAMILY).setQualifier(QUAL).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(value).build());
                    puts.add(p);
                }
                t.put(puts);
            }
            return true;
        }
    }
}

