/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.coprocessor.example.generated.RowCountProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowCountEndpoint
extends RowCountProtos.RowCountService
implements RegionCoprocessor {
    private RegionCoprocessorEnvironment env;

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRowCount(RpcController controller, RowCountProtos.CountRequest request, RpcCallback<RowCountProtos.CountResponse> done) {
        Scan scan = new Scan();
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        RowCountProtos.CountResponse response = null;
        RegionScanner scanner = null;
        try {
            scanner = this.env.getRegion().getScanner(scan);
            ArrayList results = new ArrayList();
            boolean hasMore = false;
            byte[] lastRow = null;
            long count = 0L;
            do {
                hasMore = scanner.next(results);
                for (Cell kv : results) {
                    byte[] currentRow = CellUtil.cloneRow((Cell)kv);
                    if (lastRow != null && Bytes.equals((byte[])lastRow, (byte[])currentRow)) continue;
                    lastRow = currentRow;
                    ++count;
                }
                results.clear();
            } while (hasMore);
            response = RowCountProtos.CountResponse.newBuilder().setCount(count).build();
        }
        catch (IOException ioe) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)ioe);
        }
        finally {
            if (scanner != null) {
                IOUtils.closeQuietly((Closeable)scanner);
            }
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void getKeyValueCount(RpcController controller, RowCountProtos.CountRequest request, RpcCallback<RowCountProtos.CountResponse> done) {
        response = null;
        scanner = null;
        try {
            scanner = this.env.getRegion().getScanner(new Scan());
            results = new ArrayList<E>();
            hasMore = false;
            count = 0L;
            do {
                hasMore = scanner.next(results);
                count += (long)Iterables.size(results);
                results.clear();
            } while (hasMore);
            response = RowCountProtos.CountResponse.newBuilder().setCount(count).build();
            ** if (scanner == null) goto lbl-1000
        }
        catch (IOException ioe) {
            try {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)ioe);
                ** if (scanner == null) goto lbl-1000
            }
            catch (Throwable var10_10) {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
                throw var10_10;
            }
lbl-1000:
            // 1 sources

            {
                IOUtils.closeQuietly((Closeable)scanner);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((Closeable)scanner);
        }
lbl-1000:
        // 2 sources

        {
        }
        done.run(response);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

