/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.File;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClientUtils;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.yetus.audience.InterfaceAudience;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HttpDoAsClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDoAsClient.class);
    protected static int port;
    protected static String host;
    private static boolean secure;
    protected static String doAsUser;
    protected static String principal;
    protected static String keyTab;

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args.length > 6) {
            System.out.println("Invalid arguments!");
            System.out.println("Usage: HttpDoAsClient host port doAsUserName [security=true] [principal] [keytab]");
            System.exit(-1);
        }
        host = args[0];
        port = Integer.parseInt(args[1]);
        doAsUser = args[2];
        if (args.length > 3) {
            secure = Boolean.parseBoolean(args[3]);
            if (args.length > 4) {
                principal = args[4];
                keyTab = args[5];
                if (!new File(keyTab).exists()) {
                    System.err.printf("ERROR: KeyTab File %s not found %n", keyTab);
                    System.exit(-1);
                }
            } else {
                principal = HttpDoAsClient.getSubject().getPrincipals().iterator().next().getName();
            }
        }
        final HttpDoAsClient client = new HttpDoAsClient();
        Subject.doAs(HttpDoAsClient.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.run();
                return null;
            }
        });
    }

    HttpDoAsClient() {
    }

    private byte[] bytes(String s) {
        return Bytes.toBytes((String)s);
    }

    private void run() throws Exception {
        TSocket transport = new TSocket(host, port);
        transport.open();
        String url = "http://" + host + ":" + port;
        THttpClient httpClient = new THttpClient(url);
        httpClient.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)httpClient);
        Hbase.Client client = new Hbase.Client((TProtocol)protocol);
        byte[] t = this.bytes("demo_table");
        System.out.println("scanning tables...");
        for (ByteBuffer name : this.refresh(client, httpClient).getTableNames()) {
            System.out.println("  found: " + ClientUtils.utf8(name));
            if (!ClientUtils.utf8(name).equals(ClientUtils.utf8(t))) continue;
            if (this.refresh(client, httpClient).isTableEnabled(name)) {
                System.out.println("    disabling table: " + ClientUtils.utf8(name));
                this.refresh(client, httpClient).disableTable(name);
            }
            System.out.println("    deleting table: " + ClientUtils.utf8(name));
            this.refresh(client, httpClient).deleteTable(name);
        }
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>(2);
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("entry:"));
        col.timeToLive = Integer.MAX_VALUE;
        col.maxVersions = 10;
        columns.add(col);
        col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("unused:"));
        col.timeToLive = Integer.MAX_VALUE;
        columns.add(col);
        System.out.println("creating table: " + ClientUtils.utf8(t));
        try {
            this.refresh(client, httpClient).createTable(ByteBuffer.wrap(t), columns);
        }
        catch (AlreadyExists ae) {
            System.out.println("WARN: " + ae.message);
        }
        System.out.println("column families in " + ClientUtils.utf8(t) + ": ");
        Map columnMap = this.refresh(client, httpClient).getColumnDescriptors(ByteBuffer.wrap(t));
        for (ColumnDescriptor col2 : columnMap.values()) {
            System.out.println("  column: " + ClientUtils.utf8(col2.name) + ", maxVer: " + col2.maxVersions);
        }
        transport.close();
        httpClient.close();
    }

    private Hbase.Client refresh(Hbase.Client client, THttpClient httpClient) {
        httpClient.setCustomHeader("doAs", doAsUser);
        if (secure) {
            try {
                httpClient.setCustomHeader("Authorization", this.generateTicket());
            }
            catch (GSSException e) {
                LOG.error("Kerberos authentication failed", (Throwable)e);
            }
        }
        return client;
    }

    private String generateTicket() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
        Oid KERB_V5_OID = new Oid("1.2.840.113554.1.2.2");
        GSSName clientName = manager.createName(principal, krb5PrincipalOid);
        GSSCredential clientCred = manager.createCredential(clientName, 28800, KERB_V5_OID, 1);
        GSSName serverName = manager.createName(principal, krb5PrincipalOid);
        GSSContext context = manager.createContext(serverName, KERB_V5_OID, clientCred, 0);
        context.requestMutualAuth(true);
        context.requestConf(false);
        context.requestInteg(true);
        byte[] outToken = context.initSecContext(new byte[0], 0, 0);
        StringBuilder outputBuffer = new StringBuilder();
        outputBuffer.append("Negotiate ");
        outputBuffer.append(Bytes.toString((byte[])Base64.getEncoder().encode(outToken)));
        System.out.print("Ticket is: " + outputBuffer);
        return outputBuffer.toString();
    }

    static Subject getSubject() throws Exception {
        LoginContext context;
        if (!secure) {
            return new Subject();
        }
        if (keyTab != null) {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            context = new LoginContext("", subject, null, new KerberosConfiguration(principal, keyTab));
        } else {
            context = new LoginContext("", new Subject(), null, new KerberosConfiguration());
        }
        context.login();
        return context.getSubject();
    }

    static {
        secure = false;
        doAsUser = null;
        principal = null;
        keyTab = null;
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String principal;
        private String keyTab;

        public KerberosConfiguration() {
        }

        public KerberosConfiguration(String principal, String keyTab) {
            this.principal = principal;
            this.keyTab = keyTab;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (this.principal != null && this.keyTab != null) {
                options.put("principal", this.principal);
                options.put("keyTab", this.keyTab);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
            } else {
                options.put("useKeyTab", "false");
                options.put("storeKey", "false");
            }
            options.put("doNotPrompt", "true");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                options.put("ticketCache", ticketCache);
            }
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

