/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.io.IOException;
import org.apache.hadoop.hbase.example.protobuf.generated.CellMessage;
import org.apache.hadoop.hbase.types.PBType;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PBCell
extends PBType<CellMessage.Cell> {
    public Class<CellMessage.Cell> encodedClass() {
        return CellMessage.Cell.class;
    }

    public int skip(PositionedByteRange src) {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        CodedInputStream is = PBCell.inputStreamFromByteRange(src);
        is.setSizeLimit(src.getLength());
        try {
            builder.mergeFrom(is);
            int consumed = is.getTotalBytesRead();
            src.setPosition(src.getPosition() + consumed);
            return consumed;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while skipping type.", e);
        }
    }

    public CellMessage.Cell decode(PositionedByteRange src) {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        CodedInputStream is = PBCell.inputStreamFromByteRange(src);
        is.setSizeLimit(src.getLength());
        try {
            CellMessage.Cell ret = ((CellMessage.Cell.Builder)builder.mergeFrom(is)).build();
            src.setPosition(src.getPosition() + is.getTotalBytesRead());
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while decoding type.", e);
        }
    }

    public int encode(PositionedByteRange dst, CellMessage.Cell val) {
        CodedOutputStream os = PBCell.outputStreamFromByteRange(dst);
        try {
            int before = os.spaceLeft();
            val.writeTo(os);
            int after = os.spaceLeft();
            int written = before - after;
            dst.setPosition(dst.getPosition() + written);
            return written;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while encoding type.", e);
        }
    }
}

