/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.TableMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestTableMapping {
    private String hostName1 = "1.2.3.4";
    private String hostName2 = "5.6.7.8";

    @Test
    public void testResolve() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testResolve", ".txt");
        Files.asCharSink((File)mapFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)(this.hostName1 + " /rack1\n" + this.hostName2 + "\t/rack2\n"));
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.hostName1);
        names.add(this.hostName2);
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/rack1", result.get(0));
        Assert.assertEquals((Object)"/rack2", result.get(1));
    }

    @Test
    public void testTableCaching() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testTableCaching", ".txt");
        Files.asCharSink((File)mapFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)(this.hostName1 + " /rack1\n" + this.hostName2 + "\t/rack2\n"));
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.hostName1);
        names.add(this.hostName2);
        List result1 = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result1.size());
        Assert.assertEquals((Object)"/rack1", result1.get(0));
        Assert.assertEquals((Object)"/rack2", result1.get(1));
        conf.set("net.topology.table.file.name", "some bad value for a file");
        List result2 = mapping.resolve(names);
        Assert.assertEquals((Object)result1, (Object)result2);
    }

    @Test
    public void testNoFile() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.hostName1);
        names.add(this.hostName2);
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/default-rack", result.get(0));
        Assert.assertEquals((Object)"/default-rack", result.get(1));
    }

    @Test
    public void testFileDoesNotExist() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", "/this/file/does/not/exist");
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.hostName1);
        names.add(this.hostName2);
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals(result.get(0), (Object)"/default-rack");
        Assert.assertEquals(result.get(1), (Object)"/default-rack");
    }

    @Test
    public void testClearingCachedMappings() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testClearingCachedMappings", ".txt");
        Files.asCharSink((File)mapFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)(this.hostName1 + " /rack1\n" + this.hostName2 + "\t/rack2\n"));
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.hostName1);
        names.add(this.hostName2);
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/rack1", result.get(0));
        Assert.assertEquals((Object)"/rack2", result.get(1));
        Files.asCharSink((File)mapFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
        mapping.reloadCachedMappings();
        names = new ArrayList();
        names.add(this.hostName1);
        names.add(this.hostName2);
        result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/default-rack", result.get(0));
        Assert.assertEquals((Object)"/default-rack", result.get(1));
    }

    @Test(timeout=60000L)
    public void testBadFile() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testBadFile", ".txt");
        Files.asCharSink((File)mapFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"bad contents");
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.hostName1);
        names.add(this.hostName2);
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals(result.get(0), (Object)"/default-rack");
        Assert.assertEquals(result.get(1), (Object)"/default-rack");
    }
}

