/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.backoff.HBaseServerExceptionPauseManager;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AsyncRpcRetryingCaller<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRpcRetryingCaller.class);
    private final Timer retryTimer;
    private final int priority;
    private final long startNs;
    private int tries = 1;
    private final int maxAttempts;
    private final int startLogErrorsCnt;
    private final List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions;
    private final long rpcTimeoutNs;
    protected final long operationTimeoutNs;
    protected final AsyncConnectionImpl conn;
    protected final CompletableFuture<T> future;
    protected final HBaseRpcController controller;
    private final HBaseServerExceptionPauseManager pauseManager;

    public AsyncRpcRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, int priority, long pauseNs, long pauseNsForServerOverloaded, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt, Map<String, byte[]> requestAttributes) {
        this.retryTimer = retryTimer;
        this.conn = conn;
        this.priority = priority;
        this.maxAttempts = maxAttempts;
        this.operationTimeoutNs = operationTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.future = new CompletableFuture();
        this.controller = conn.rpcControllerFactory.newController();
        this.controller.setPriority(priority);
        this.controller.setRequestAttributes(requestAttributes);
        this.exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.startNs = System.nanoTime();
        this.pauseManager = new HBaseServerExceptionPauseManager(pauseNs, pauseNsForServerOverloaded, operationTimeoutNs);
    }

    private long elapsedMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
    }

    protected final long remainingTimeNs() {
        return this.pauseManager.remainingTimeNs(this.startNs);
    }

    protected final void completeExceptionally() {
        this.future.completeExceptionally(new RetriesExhaustedException(this.tries - 1, this.exceptions));
    }

    protected final void resetCallTimeout() {
        long callTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            callTimeoutNs = this.remainingTimeNs();
            if (callTimeoutNs <= 0L) {
                this.completeExceptionally();
                return;
            }
            callTimeoutNs = Math.min(callTimeoutNs, this.rpcTimeoutNs);
        } else {
            callTimeoutNs = this.rpcTimeoutNs;
        }
        ConnectionUtils.resetController(this.controller, callTimeoutNs, this.priority, this.getTableName().orElse(null));
    }

    private void tryScheduleRetry(Throwable error) {
        OptionalLong maybePauseNsToUse = this.pauseManager.getPauseNsFromException(error, this.tries, this.startNs);
        if (!maybePauseNsToUse.isPresent()) {
            this.completeExceptionally();
            return;
        }
        long delayNs = maybePauseNsToUse.getAsLong();
        ++this.tries;
        if (HBaseServerException.isServerOverloaded(error)) {
            Optional<MetricsConnection> metrics = this.conn.getConnectionMetrics();
            metrics.ifPresent(m -> m.incrementServerOverloadedBackoffTime(delayNs, TimeUnit.NANOSECONDS));
        }
        this.retryTimer.newTimeout(t -> this.doCall(), delayNs, TimeUnit.NANOSECONDS);
    }

    protected Optional<TableName> getTableName() {
        return Optional.empty();
    }

    protected Throwable preProcessError(Throwable error) {
        return error;
    }

    protected final void onError(Throwable t, Supplier<String> errMsg, Consumer<Throwable> updateCachedLocation) {
        if (this.future.isDone()) {
            LOG.debug("The future is already done, canceled={}, give up retrying", (Object)this.future.isCancelled());
            return;
        }
        Throwable error = this.preProcessError(ConnectionUtils.translateException(t));
        if (error instanceof DoNotRetryIOException && !(error instanceof ScannerResetException)) {
            this.future.completeExceptionally(error);
            return;
        }
        if (this.tries > this.startLogErrorsCnt) {
            LOG.warn(errMsg.get() + ", tries = " + this.tries + ", maxAttempts = " + this.maxAttempts + ", timeout = " + TimeUnit.NANOSECONDS.toMillis(this.operationTimeoutNs) + " ms, time elapsed = " + this.elapsedMs() + " ms", error);
        }
        updateCachedLocation.accept(error);
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(error, EnvironmentEdgeManager.currentTime(), "");
        this.exceptions.add(qt);
        if (this.tries >= this.maxAttempts) {
            this.completeExceptionally();
            return;
        }
        if (error instanceof NotServingRegionException || error instanceof RegionOfflineException) {
            Optional<TableName> tableName = this.getTableName();
            if (tableName.isPresent()) {
                FutureUtils.addListener(this.conn.getAdmin().isTableDisabled(tableName.get()), (disabled, e) -> {
                    if (e != null) {
                        if (e instanceof TableNotFoundException) {
                            this.future.completeExceptionally((Throwable)e);
                        } else {
                            this.tryScheduleRetry(error);
                        }
                        return;
                    }
                    if (disabled.booleanValue()) {
                        this.future.completeExceptionally(new TableNotEnabledException((TableName)tableName.get()));
                    } else {
                        this.tryScheduleRetry(error);
                    }
                });
            } else {
                this.tryScheduleRetry(error);
            }
        } else {
            this.tryScheduleRetry(error);
        }
    }

    protected abstract void doCall();

    CompletableFuture<T> call() {
        this.doCall();
        return this.future;
    }
}

