/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AdminOverAsyncAdmin;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorOverAsyncBufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionLocatorOverAsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableOverAsyncTable;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ConnectionOverAsyncConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionOverAsyncConnection.class);
    private volatile boolean aborted = false;
    private volatile ExecutorService batchPool = null;
    private final AsyncConnectionImpl conn;
    private final ConnectionConfiguration connConf;

    ConnectionOverAsyncConnection(AsyncConnectionImpl conn) {
        this.conn = conn;
        this.connConf = new ConnectionConfiguration(conn.getConfiguration());
    }

    @Override
    public void abort(String why, Throwable error) {
        if (error != null) {
            LOG.error(HBaseMarkers.FATAL, why, error);
        } else {
            LOG.error(HBaseMarkers.FATAL, why);
        }
        this.aborted = true;
        try {
            Closeables.close(this, true);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conn.getConfiguration();
    }

    @Override
    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        AsyncBufferedMutatorBuilder builder = this.conn.getBufferedMutatorBuilder(params.getTableName());
        if (params.getRpcTimeout() != -1) {
            builder.setRpcTimeout(params.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        if (params.getOperationTimeout() != -1) {
            builder.setOperationTimeout(params.getOperationTimeout(), TimeUnit.MILLISECONDS);
        }
        if (params.getWriteBufferSize() != -1L) {
            builder.setWriteBufferSize(params.getWriteBufferSize());
        }
        if (params.getWriteBufferPeriodicFlushTimeoutMs() != -1L) {
            builder.setWriteBufferPeriodicFlush(params.getWriteBufferPeriodicFlushTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        if (params.getMaxKeyValueSize() != -1) {
            builder.setMaxKeyValueSize(params.getMaxKeyValueSize());
        }
        return new BufferedMutatorOverAsyncBufferedMutator(builder.build(), params.getListener());
    }

    @Override
    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new RegionLocatorOverAsyncTableRegionLocator(this.conn.getRegionLocator(tableName));
    }

    @Override
    public void clearRegionLocationCache() {
        this.conn.clearRegionLocationCache();
    }

    @Override
    public Admin getAdmin() throws IOException {
        return new AdminOverAsyncAdmin(this, (RawAsyncHBaseAdmin)this.conn.getAdmin());
    }

    @Override
    public void close() throws IOException {
        this.conn.close();
    }

    synchronized void closePool() {
        ExecutorService batchPool = this.batchPool;
        if (batchPool != null) {
            ConnectionUtils.shutdownPool(batchPool);
            this.batchPool = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    private ThreadPoolExecutor createThreadPool() {
        Configuration conf = this.conn.getConfiguration();
        int threads = conf.getInt("hbase.hconnection.threads.max", 256);
        long keepAliveTime = conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(threads * conf.getInt("hbase.client.max.total.tasks", 100));
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(threads, threads, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.toString() + "-shared-%d").build());
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getBatchPool() throws IOException {
        if (this.batchPool == null) {
            ConnectionOverAsyncConnection connectionOverAsyncConnection = this;
            synchronized (connectionOverAsyncConnection) {
                if (this.isClosed()) {
                    throw new DoNotRetryIOException("Connection is closed");
                }
                if (this.batchPool == null) {
                    this.batchPool = this.createThreadPool();
                }
            }
        }
        return this.batchPool;
    }

    @Override
    public TableBuilder getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new TableBuilderBase(tableName, this.connConf){

            @Override
            public Table build() {
                ConcurrentMapUtils.IOExceptionSupplier<ExecutorService> poolSupplier = pool != null ? () -> pool : () -> ConnectionOverAsyncConnection.this.getBatchPool();
                AsyncTableBuilder<AdvancedScanResultConsumer> tableBuilder = ConnectionOverAsyncConnection.this.conn.getTableBuilder(this.tableName).setRpcTimeout(this.rpcTimeout, TimeUnit.MILLISECONDS).setReadRpcTimeout(this.readRpcTimeout, TimeUnit.MILLISECONDS).setWriteRpcTimeout(this.writeRpcTimeout, TimeUnit.MILLISECONDS).setOperationTimeout(this.operationTimeout, TimeUnit.MILLISECONDS);
                this.requestAttributes.forEach(tableBuilder::setRequestAttribute);
                return new TableOverAsyncTable(ConnectionOverAsyncConnection.this.conn, tableBuilder.build(), poolSupplier);
            }
        };
    }

    @Override
    public AsyncConnection toAsyncConnection() {
        return this.conn;
    }

    @Override
    public String getClusterId() {
        return this.conn.getClusterId();
    }

    @Override
    public Hbck getHbck() throws IOException {
        return FutureUtils.get(this.conn.getHbck());
    }

    @Override
    public Hbck getHbck(ServerName masterServer) throws IOException {
        return this.conn.getHbck(masterServer);
    }

    public String toString() {
        return "connection-over-async-connection-0x" + Integer.toHexString(this.hashCode());
    }
}

