/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class DictionaryCache {
    public static final String DICTIONARY_MAX_SIZE_KEY = "hbase.io.compress.dictionary.max.size";
    public static final int DEFAULT_DICTIONARY_MAX_SIZE = 0xA00000;
    public static final String RESOURCE_SCHEME = "resource://";
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryCache.class);
    private static volatile LoadingCache<String, byte[]> CACHE;

    private DictionaryCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static byte[] getDictionary(final Configuration conf, final String path) throws IOException {
        if (path == null) return null;
        if (path.isEmpty()) {
            return null;
        }
        if (CACHE == null) {
            Class<DictionaryCache> clazz = DictionaryCache.class;
            // MONITORENTER : org.apache.hadoop.hbase.io.compress.DictionaryCache.class
            if (CACHE == null) {
                final int maxSize = conf.getInt(DICTIONARY_MAX_SIZE_KEY, 0xA00000);
                CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build(new CacheLoader<String, byte[]>(){

                    @Override
                    public byte[] load(String s) throws Exception {
                        byte[] bytes = path.startsWith(DictionaryCache.RESOURCE_SCHEME) ? DictionaryCache.loadFromResource(conf, path, maxSize) : DictionaryCache.loadFromHadoopFs(conf, path, maxSize);
                        LOG.info("Loaded dictionary from {} (size {})", (Object)s, (Object)bytes.length);
                        return bytes;
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        try {
            return CACHE.get(path);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFromResource(Configuration conf, String s, int maxSize) throws IOException {
        if (!s.startsWith(RESOURCE_SCHEME)) {
            throw new IOException("Path does not start with resource://");
        }
        String path = s.substring(RESOURCE_SCHEME.length(), s.length());
        LOG.info("Loading resource {}", (Object)path);
        InputStream in = DictionaryCache.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new FileNotFoundException("Resource " + path + " not found");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[8192];
            int len = 0;
            do {
                if ((n = in.read(buffer)) <= 0) continue;
                if ((len += n) > maxSize) {
                    throw new IOException("Dictionary " + s + " is too large, limit=" + maxSize);
                }
                baos.write(buffer, 0, n);
            } while (n > 0);
        }
        finally {
            in.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadFromHadoopFs(Configuration conf, String s, int maxSize) throws IOException {
        Path path = new Path(s);
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        LOG.info("Loading file {}", (Object)path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FSDataInputStream in = fs.open(path);){
            int n;
            byte[] buffer = new byte[8192];
            int len = 0;
            do {
                if ((n = in.read(buffer)) <= 0) continue;
                if ((len += n) > maxSize) {
                    throw new IOException("Dictionary " + s + " is too large, limit=" + maxSize);
                }
                baos.write(buffer, 0, n);
            } while (n > 0);
        }
        return baos.toByteArray();
    }

    public static boolean contains(String dictionaryPath) {
        if (CACHE != null) {
            return CACHE.asMap().containsKey(dictionaryPath);
        }
        return false;
    }
}

