/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RSGroupAdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RequestConverter {
    private RequestConverter() {
    }

    public static ClientProtos.GetRequest buildGetRequest(byte[] regionName, Get get) throws IOException {
        ClientProtos.GetRequest.Builder builder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setGet(ProtobufUtil.toGet(get));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Filter filter, TimeRange timeRange, Mutation mutation, long nonceGroup, long nonce) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        if (mutation instanceof Increment || mutation instanceof Append) {
            builder.setMutation(ProtobufUtil.toMutation(RequestConverter.getMutationType(mutation), mutation, nonce)).setNonceGroup(nonceGroup);
        } else {
            builder.setMutation(ProtobufUtil.toMutation(RequestConverter.getMutationType(mutation), mutation));
        }
        return builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).setCondition(ProtobufUtil.toCondition(row, family, qualifier, op, value, filter, timeRange)).build();
    }

    public static ClientProtos.MultiRequest buildMultiRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Filter filter, TimeRange timeRange, RowMutations rowMutations, long nonceGroup, long nonce) throws IOException {
        return RequestConverter.buildMultiRequest(regionName, rowMutations, ProtobufUtil.toCondition(row, family, qualifier, op, value, filter, timeRange), nonceGroup, nonce);
    }

    public static ClientProtos.MultiRequest buildMultiRequest(byte[] regionName, RowMutations rowMutations, long nonceGroup, long nonce) throws IOException {
        return RequestConverter.buildMultiRequest(regionName, rowMutations, null, nonceGroup, nonce);
    }

    private static ClientProtos.MultiRequest buildMultiRequest(byte[] regionName, RowMutations rowMutations, ClientProtos.Condition condition, long nonceGroup, long nonce) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(ClientProtos.RegionAction.newBuilder(), regionName);
        builder.setAtomic(true);
        boolean hasNonce = false;
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto mp;
            mutationBuilder.clear();
            if (mutation instanceof Increment || mutation instanceof Append) {
                mp = ProtobufUtil.toMutation(RequestConverter.getMutationType(mutation), mutation, mutationBuilder, nonce);
                hasNonce = true;
            } else {
                mp = ProtobufUtil.toMutation(RequestConverter.getMutationType(mutation), mutation, mutationBuilder);
            }
            actionBuilder.clear();
            actionBuilder.setMutation(mp);
            builder.addAction(actionBuilder.build());
        }
        if (condition != null) {
            builder.setCondition(condition);
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        if (hasNonce) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        return multiRequestBuilder.addRegionAction(builder.build()).build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Put put) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, ClientProtos.MutationProto.newBuilder()));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Append append, long nonceGroup, long nonce) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (nonce != 0L && nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, append, ClientProtos.MutationProto.newBuilder(), nonce));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Increment increment, long nonceGroup, long nonce) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (nonce != 0L && nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.INCREMENT, increment, ClientProtos.MutationProto.newBuilder(), nonce));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Delete delete) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete, ClientProtos.MutationProto.newBuilder()));
        return builder.build();
    }

    public static ClientProtos.RegionAction.Builder getRegionActionBuilderWithRegion(ClientProtos.RegionAction.Builder regionActionBuilder, byte[] regionName) {
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        regionActionBuilder.setRegion(region);
        return regionActionBuilder;
    }

    public static ClientProtos.ScanRequest buildScanRequest(byte[] regionName, Scan scan, int numberOfRows, boolean closeScanner) throws IOException {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setRegion(region);
        builder.setScan(ProtobufUtil.toScan(scan));
        builder.setClientHandlesPartials(true);
        builder.setClientHandlesHeartbeats(true);
        builder.setTrackScanMetrics(scan.isScanMetricsEnabled());
        if (scan.getLimit() > 0) {
            builder.setLimitOfRows(scan.getLimit());
        }
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner, boolean trackMetrics) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        builder.setClientHandlesPartials(true);
        builder.setClientHandlesHeartbeats(true);
        builder.setTrackScanMetrics(trackMetrics);
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner, long nextCallSeq, boolean trackMetrics, boolean renew, int limitOfRows) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        builder.setNextCallSeq(nextCallSeq);
        builder.setClientHandlesPartials(true);
        builder.setClientHandlesHeartbeats(true);
        builder.setTrackScanMetrics(trackMetrics);
        builder.setRenew(renew);
        if (limitOfRows > 0) {
            builder.setLimitOfRows(limitOfRows);
        }
        return builder.build();
    }

    public static ClientProtos.BulkLoadHFileRequest buildBulkLoadHFileRequest(List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum, Token<?> userToken, String bulkToken, boolean copyFiles, List<String> clusterIds, boolean replicate) {
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        ClientProtos.DelegationToken protoDT = null;
        if (userToken != null) {
            protoDT = ClientProtos.DelegationToken.newBuilder().setIdentifier(UnsafeByteOperations.unsafeWrap(userToken.getIdentifier())).setPassword(UnsafeByteOperations.unsafeWrap(userToken.getPassword())).setKind(userToken.getKind().toString()).setService(userToken.getService().toString()).build();
        }
        ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath> protoFamilyPaths = new ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath>(familyPaths.size());
        if (!familyPaths.isEmpty()) {
            ClientProtos.BulkLoadHFileRequest.FamilyPath.Builder pathBuilder = ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder();
            for (Pair<byte[], String> el : familyPaths) {
                protoFamilyPaths.add(pathBuilder.setFamily(UnsafeByteOperations.unsafeWrap(el.getFirst())).setPath(el.getSecond()).build());
            }
            pathBuilder.clear();
        }
        ClientProtos.BulkLoadHFileRequest.Builder request = ClientProtos.BulkLoadHFileRequest.newBuilder().setRegion(region).setAssignSeqNum(assignSeqNum).addAllFamilyPath(protoFamilyPaths);
        if (userToken != null) {
            request.setFsToken(protoDT);
        }
        if (bulkToken != null) {
            request.setBulkToken(bulkToken);
        }
        request.setCopyFile(copyFiles);
        if (clusterIds != null) {
            request.addAllClusterIds(clusterIds);
        }
        request.setReplicate(replicate);
        return request.build();
    }

    public static void buildNoDataRegionActions(byte[] regionName, Iterable<Action> actions, List<CellScannable> cells, ClientProtos.MultiRequest.Builder multiRequestBuilder, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder, long nonceGroup, Map<Integer, Integer> indexMap) throws IOException {
        regionActionBuilder.clear();
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(regionActionBuilder, regionName);
        ClientProtos.CoprocessorServiceCall.Builder cpBuilder = null;
        boolean hasNonce = false;
        ArrayList<Action> rowMutationsList = new ArrayList<Action>();
        ArrayList<Action> checkAndMutates = new ArrayList<Action>();
        for (Action action : actions) {
            Row row = action.getAction();
            actionBuilder.clear();
            actionBuilder.setIndex(action.getOriginalIndex());
            mutationBuilder.clear();
            if (row instanceof Get) {
                Get g = (Get)row;
                builder.addAction(actionBuilder.setGet(ProtobufUtil.toGet(g)));
                continue;
            }
            if (row instanceof Put) {
                RequestConverter.buildNoDataRegionAction((Put)row, cells, builder, actionBuilder, mutationBuilder);
                continue;
            }
            if (row instanceof Delete) {
                RequestConverter.buildNoDataRegionAction((Delete)row, cells, builder, actionBuilder, mutationBuilder);
                continue;
            }
            if (row instanceof Append) {
                RequestConverter.buildNoDataRegionAction((Append)row, cells, action.getNonce(), builder, actionBuilder, mutationBuilder);
                hasNonce = true;
                continue;
            }
            if (row instanceof Increment) {
                RequestConverter.buildNoDataRegionAction((Increment)row, cells, action.getNonce(), builder, actionBuilder, mutationBuilder);
                hasNonce = true;
                continue;
            }
            if (row instanceof RegionCoprocessorServiceExec) {
                RegionCoprocessorServiceExec exec = (RegionCoprocessorServiceExec)row;
                ByteString value = UnsafeByteOperations.unsafeWrap(exec.getRequest().toByteArray());
                if (cpBuilder == null) {
                    cpBuilder = ClientProtos.CoprocessorServiceCall.newBuilder();
                } else {
                    cpBuilder.clear();
                }
                builder.addAction(actionBuilder.setServiceCall(cpBuilder.setRow(UnsafeByteOperations.unsafeWrap(exec.getRow())).setServiceName(exec.getMethod().getService().getFullName()).setMethodName(exec.getMethod().getName()).setRequest(value)));
                continue;
            }
            if (row instanceof RowMutations) {
                rowMutationsList.add(action);
                continue;
            }
            if (row instanceof CheckAndMutate) {
                checkAndMutates.add(action);
                continue;
            }
            throw new DoNotRetryIOException("Multi doesn't support " + row.getClass().getName());
        }
        if (builder.getActionCount() > 0) {
            multiRequestBuilder.addRegionAction(builder.build());
        }
        for (Action action : rowMutationsList) {
            builder.clear();
            RequestConverter.getRegionActionBuilderWithRegion(builder, regionName);
            boolean hasIncrementOrAppend = RequestConverter.buildNoDataRegionAction((RowMutations)action.getAction(), cells, action.getNonce(), builder, actionBuilder, mutationBuilder);
            if (hasIncrementOrAppend) {
                hasNonce = true;
            }
            builder.setAtomic(true);
            multiRequestBuilder.addRegionAction(builder.build());
            indexMap.put(multiRequestBuilder.getRegionActionCount() - 1, action.getOriginalIndex());
        }
        for (Action action : checkAndMutates) {
            builder.clear();
            RequestConverter.getRegionActionBuilderWithRegion(builder, regionName);
            CheckAndMutate cam = (CheckAndMutate)action.getAction();
            builder.setCondition(ProtobufUtil.toCondition(cam.getRow(), cam.getFamily(), cam.getQualifier(), cam.getCompareOp(), cam.getValue(), cam.getFilter(), cam.getTimeRange()));
            if (cam.getAction() instanceof Put) {
                actionBuilder.clear();
                mutationBuilder.clear();
                RequestConverter.buildNoDataRegionAction((Put)cam.getAction(), cells, builder, actionBuilder, mutationBuilder);
            } else if (cam.getAction() instanceof Delete) {
                actionBuilder.clear();
                mutationBuilder.clear();
                RequestConverter.buildNoDataRegionAction((Delete)cam.getAction(), cells, builder, actionBuilder, mutationBuilder);
            } else if (cam.getAction() instanceof Increment) {
                actionBuilder.clear();
                mutationBuilder.clear();
                RequestConverter.buildNoDataRegionAction((Increment)cam.getAction(), cells, action.getNonce(), builder, actionBuilder, mutationBuilder);
                hasNonce = true;
            } else if (cam.getAction() instanceof Append) {
                actionBuilder.clear();
                mutationBuilder.clear();
                RequestConverter.buildNoDataRegionAction((Append)cam.getAction(), cells, action.getNonce(), builder, actionBuilder, mutationBuilder);
                hasNonce = true;
            } else if (cam.getAction() instanceof RowMutations) {
                boolean hasIncrementOrAppend = RequestConverter.buildNoDataRegionAction((RowMutations)cam.getAction(), cells, action.getNonce(), builder, actionBuilder, mutationBuilder);
                if (hasIncrementOrAppend) {
                    hasNonce = true;
                }
                builder.setAtomic(true);
            } else {
                throw new DoNotRetryIOException("CheckAndMutate doesn't support " + cam.getAction().getClass().getName());
            }
            multiRequestBuilder.addRegionAction(builder.build());
            indexMap.put(multiRequestBuilder.getRegionActionCount() - 1, action.getOriginalIndex());
        }
        if (!multiRequestBuilder.hasNonceGroup() && hasNonce) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
    }

    private static void buildNoDataRegionAction(Put put, List<CellScannable> cells, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        cells.add(put);
        regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.PUT, put, mutationBuilder)));
    }

    private static void buildNoDataRegionAction(Delete delete, List<CellScannable> cells, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        int size = delete.size();
        if (size > 0) {
            cells.add(delete);
            regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.DELETE, delete, mutationBuilder)));
        } else {
            regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete, mutationBuilder)));
        }
    }

    private static void buildNoDataRegionAction(Increment increment, List<CellScannable> cells, long nonce, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        cells.add(increment);
        regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.INCREMENT, increment, mutationBuilder, nonce)));
    }

    private static void buildNoDataRegionAction(Append append, List<CellScannable> cells, long nonce, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        cells.add(append);
        regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.APPEND, append, mutationBuilder, nonce)));
    }

    private static boolean buildNoDataRegionAction(RowMutations rowMutations, List<CellScannable> cells, long nonce, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        boolean ret = false;
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto mp;
            mutationBuilder.clear();
            if (mutation instanceof Increment || mutation instanceof Append) {
                mp = ProtobufUtil.toMutationNoData(RequestConverter.getMutationType(mutation), mutation, mutationBuilder, nonce);
                ret = true;
            } else {
                mp = ProtobufUtil.toMutationNoData(RequestConverter.getMutationType(mutation), mutation, mutationBuilder);
            }
            cells.add(mutation);
            actionBuilder.clear();
            regionActionBuilder.addAction(actionBuilder.setMutation(mp).build());
        }
        return ret;
    }

    private static ClientProtos.MutationProto.MutationType getMutationType(Mutation mutation) {
        if (mutation instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (mutation instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        if (mutation instanceof Increment) {
            return ClientProtos.MutationProto.MutationType.INCREMENT;
        }
        return ClientProtos.MutationProto.MutationType.APPEND;
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName) {
        return RequestConverter.buildGetRegionInfoRequest(regionName, false);
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName, boolean includeCompactionState) {
        return RequestConverter.buildGetRegionInfoRequest(regionName, includeCompactionState, false);
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName, boolean includeCompactionState, boolean includeBestSplitRow) {
        AdminProtos.GetRegionInfoRequest.Builder builder = AdminProtos.GetRegionInfoRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (includeCompactionState) {
            builder.setCompactionState(includeCompactionState);
        }
        if (includeBestSplitRow) {
            builder.setBestSplitRow(includeBestSplitRow);
        }
        return builder.build();
    }

    public static AdminProtos.GetRegionLoadRequest buildGetRegionLoadRequest(TableName tableName) {
        AdminProtos.GetRegionLoadRequest.Builder builder = AdminProtos.GetRegionLoadRequest.newBuilder();
        if (tableName != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        }
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionRequest buildGetOnlineRegionRequest() {
        return AdminProtos.GetOnlineRegionRequest.newBuilder().build();
    }

    public static AdminProtos.FlushRegionRequest buildFlushRegionRequest(byte[] regionName) {
        return RequestConverter.buildFlushRegionRequest(regionName, null, false);
    }

    public static AdminProtos.FlushRegionRequest buildFlushRegionRequest(byte[] regionName, byte[] columnFamily, boolean writeFlushWALMarker) {
        AdminProtos.FlushRegionRequest.Builder builder = AdminProtos.FlushRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setWriteFlushWalMarker(writeFlushWALMarker);
        if (columnFamily != null) {
            builder.setFamily(UnsafeByteOperations.unsafeWrap(columnFamily));
        }
        return builder.build();
    }

    public static AdminProtos.OpenRegionRequest buildOpenRegionRequest(ServerName server, RegionInfo region, List<ServerName> favoredNodes) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.addOpenInfo(RequestConverter.buildRegionOpenInfo(region, favoredNodes, -1L));
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        builder.setMasterSystemTime(EnvironmentEdgeManager.currentTime());
        return builder.build();
    }

    public static AdminProtos.UpdateFavoredNodesRequest buildUpdateFavoredNodesRequest(List<Pair<RegionInfo, List<ServerName>>> updateRegionInfos) {
        AdminProtos.UpdateFavoredNodesRequest.Builder ubuilder = AdminProtos.UpdateFavoredNodesRequest.newBuilder();
        if (updateRegionInfos != null && !updateRegionInfos.isEmpty()) {
            AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo.Builder builder = AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo.newBuilder();
            for (Pair<RegionInfo, List<ServerName>> pair : updateRegionInfos) {
                builder.setRegion(ProtobufUtil.toRegionInfo(pair.getFirst()));
                for (ServerName server : pair.getSecond()) {
                    builder.addFavoredNodes(ProtobufUtil.toServerName(server));
                }
                ubuilder.addUpdateInfo(builder.build());
                builder.clear();
            }
        }
        return ubuilder.build();
    }

    public static AdminProtos.WarmupRegionRequest buildWarmupRegionRequest(RegionInfo regionInfo) {
        AdminProtos.WarmupRegionRequest.Builder builder = AdminProtos.WarmupRegionRequest.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo(regionInfo));
        return builder.build();
    }

    public static AdminProtos.CompactRegionRequest buildCompactRegionRequest(byte[] regionName, boolean major, byte[] columnFamily) {
        AdminProtos.CompactRegionRequest.Builder builder = AdminProtos.CompactRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMajor(major);
        if (columnFamily != null) {
            builder.setFamily(UnsafeByteOperations.unsafeWrap(columnFamily));
        }
        return builder.build();
    }

    public static AdminProtos.RollWALWriterRequest buildRollWALWriterRequest() {
        return AdminProtos.RollWALWriterRequest.getDefaultInstance();
    }

    public static AdminProtos.GetServerInfoRequest buildGetServerInfoRequest() {
        return AdminProtos.GetServerInfoRequest.getDefaultInstance();
    }

    public static AdminProtos.StopServerRequest buildStopServerRequest(String reason) {
        AdminProtos.StopServerRequest.Builder builder = AdminProtos.StopServerRequest.newBuilder();
        builder.setReason(reason);
        return builder.build();
    }

    public static HBaseProtos.RegionSpecifier buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType type, byte[] value) {
        HBaseProtos.RegionSpecifier.Builder regionBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionBuilder.setValue(UnsafeByteOperations.unsafeWrap(value));
        regionBuilder.setType(type);
        return regionBuilder.build();
    }

    public static MasterProtos.AddColumnRequest buildAddColumnRequest(TableName tableName, ColumnFamilyDescriptor column, long nonceGroup, long nonce) {
        MasterProtos.AddColumnRequest.Builder builder = MasterProtos.AddColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnFamilies(ProtobufUtil.toColumnFamilySchema(column));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.DeleteColumnRequest buildDeleteColumnRequest(TableName tableName, byte[] columnName, long nonceGroup, long nonce) {
        MasterProtos.DeleteColumnRequest.Builder builder = MasterProtos.DeleteColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnName(UnsafeByteOperations.unsafeWrap(columnName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.ModifyColumnRequest buildModifyColumnRequest(TableName tableName, ColumnFamilyDescriptor column, long nonceGroup, long nonce) {
        MasterProtos.ModifyColumnRequest.Builder builder = MasterProtos.ModifyColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnFamilies(ProtobufUtil.toColumnFamilySchema(column));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.ModifyColumnStoreFileTrackerRequest buildModifyColumnStoreFileTrackerRequest(TableName tableName, byte[] family, String dstSFT, long nonceGroup, long nonce) {
        MasterProtos.ModifyColumnStoreFileTrackerRequest.Builder builder = MasterProtos.ModifyColumnStoreFileTrackerRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setFamily(ByteString.copyFrom(family));
        builder.setDstSft(dstSFT);
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.MoveRegionRequest buildMoveRegionRequest(byte[] encodedRegionName, ServerName destServerName) {
        MasterProtos.MoveRegionRequest.Builder builder = MasterProtos.MoveRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedRegionName));
        if (destServerName != null) {
            builder.setDestServerName(ProtobufUtil.toServerName(destServerName));
        }
        return builder.build();
    }

    public static MasterProtos.MergeTableRegionsRequest buildMergeTableRegionsRequest(byte[][] encodedNameOfdaughaterRegions, boolean forcible, long nonceGroup, long nonce) throws DeserializationException {
        MasterProtos.MergeTableRegionsRequest.Builder builder = MasterProtos.MergeTableRegionsRequest.newBuilder();
        for (int i = 0; i < encodedNameOfdaughaterRegions.length; ++i) {
            builder.addRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedNameOfdaughaterRegions[i]));
        }
        builder.setForcible(forcible);
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.SplitTableRegionRequest buildSplitTableRegionRequest(RegionInfo regionInfo, byte[] splitRow, long nonceGroup, long nonce) throws DeserializationException {
        MasterProtos.SplitTableRegionRequest.Builder builder = MasterProtos.SplitTableRegionRequest.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo(regionInfo));
        if (splitRow != null) {
            builder.setSplitRow(UnsafeByteOperations.unsafeWrap(splitRow));
        }
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.TruncateRegionRequest buildTruncateRegionRequest(RegionInfo regionInfo, long nonceGroup, long nonce) throws DeserializationException {
        MasterProtos.TruncateRegionRequest.Builder builder = MasterProtos.TruncateRegionRequest.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo(regionInfo));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.AssignRegionRequest buildAssignRegionRequest(byte[] regionName) {
        MasterProtos.AssignRegionRequest.Builder builder = MasterProtos.AssignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.UnassignRegionRequest buildUnassignRegionRequest(byte[] regionName) {
        MasterProtos.UnassignRegionRequest.Builder builder = MasterProtos.UnassignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.OfflineRegionRequest buildOfflineRegionRequest(byte[] regionName) {
        MasterProtos.OfflineRegionRequest.Builder builder = MasterProtos.OfflineRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.DeleteTableRequest buildDeleteTableRequest(TableName tableName, long nonceGroup, long nonce) {
        MasterProtos.DeleteTableRequest.Builder builder = MasterProtos.DeleteTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.TruncateTableRequest buildTruncateTableRequest(TableName tableName, boolean preserveSplits, long nonceGroup, long nonce) {
        MasterProtos.TruncateTableRequest.Builder builder = MasterProtos.TruncateTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setPreserveSplits(preserveSplits);
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.EnableTableRequest buildEnableTableRequest(TableName tableName, long nonceGroup, long nonce) {
        MasterProtos.EnableTableRequest.Builder builder = MasterProtos.EnableTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.DisableTableRequest buildDisableTableRequest(TableName tableName, long nonceGroup, long nonce) {
        MasterProtos.DisableTableRequest.Builder builder = MasterProtos.DisableTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.CreateTableRequest buildCreateTableRequest(TableDescriptor tableDescriptor, byte[][] splitKeys, long nonceGroup, long nonce) {
        MasterProtos.CreateTableRequest.Builder builder = MasterProtos.CreateTableRequest.newBuilder();
        builder.setTableSchema(ProtobufUtil.toTableSchema(tableDescriptor));
        if (splitKeys != null) {
            for (byte[] key : splitKeys) {
                builder.addSplitKeys(UnsafeByteOperations.unsafeWrap(key));
            }
        }
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.ModifyTableRequest buildModifyTableRequest(TableName tableName, TableDescriptor tableDesc, long nonceGroup, long nonce, boolean reopenRegions) {
        MasterProtos.ModifyTableRequest.Builder builder = MasterProtos.ModifyTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setTableSchema(ProtobufUtil.toTableSchema(tableDesc));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        builder.setReopenRegions(reopenRegions);
        return builder.build();
    }

    public static MasterProtos.ModifyTableStoreFileTrackerRequest buildModifyTableStoreFileTrackerRequest(TableName tableName, String dstSFT, long nonceGroup, long nonce) {
        MasterProtos.ModifyTableStoreFileTrackerRequest.Builder builder = MasterProtos.ModifyTableStoreFileTrackerRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setDstSft(dstSFT);
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(List<TableName> tableNames) {
        MasterProtos.GetTableDescriptorsRequest.Builder builder = MasterProtos.GetTableDescriptorsRequest.newBuilder();
        if (tableNames != null) {
            for (TableName tableName : tableNames) {
                builder.addTableNames(ProtobufUtil.toProtoTableName(tableName));
            }
        }
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(Pattern pattern, boolean includeSysTables) {
        MasterProtos.GetTableDescriptorsRequest.Builder builder = MasterProtos.GetTableDescriptorsRequest.newBuilder();
        if (pattern != null) {
            builder.setRegex(pattern.toString());
        }
        builder.setIncludeSysTables(includeSysTables);
        return builder.build();
    }

    public static MasterProtos.GetTableNamesRequest buildGetTableNamesRequest(Pattern pattern, boolean includeSysTables) {
        MasterProtos.GetTableNamesRequest.Builder builder = MasterProtos.GetTableNamesRequest.newBuilder();
        if (pattern != null) {
            builder.setRegex(pattern.toString());
        }
        builder.setIncludeSysTables(includeSysTables);
        return builder.build();
    }

    public static MasterProtos.SetTableStateInMetaRequest buildSetTableStateInMetaRequest(TableState state) {
        return MasterProtos.SetTableStateInMetaRequest.newBuilder().setTableState(state.convert()).setTableName(ProtobufUtil.toProtoTableName(state.getTableName())).build();
    }

    public static MasterProtos.SetRegionStateInMetaRequest buildSetRegionStateInMetaRequest(Map<String, RegionState.State> nameOrEncodedName2State) {
        MasterProtos.SetRegionStateInMetaRequest.Builder builder = MasterProtos.SetRegionStateInMetaRequest.newBuilder();
        nameOrEncodedName2State.forEach((name, state) -> {
            byte[] bytes = Bytes.toBytes(name);
            HBaseProtos.RegionSpecifier spec = RegionInfo.isEncodedRegionName(bytes) ? RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, bytes) : RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, bytes);
            builder.addStates(MasterProtos.RegionSpecifierAndState.newBuilder().setRegionSpecifier(spec).setState(state.convert()).build());
        });
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(TableName tableName) {
        return MasterProtos.GetTableDescriptorsRequest.newBuilder().addTableNames(ProtobufUtil.toProtoTableName(tableName)).build();
    }

    public static MasterProtos.IsMasterRunningRequest buildIsMasterRunningRequest() {
        return MasterProtos.IsMasterRunningRequest.newBuilder().build();
    }

    public static MasterProtos.SetBalancerRunningRequest buildSetBalancerRunningRequest(boolean on, boolean synchronous) {
        return MasterProtos.SetBalancerRunningRequest.newBuilder().setOn(on).setSynchronous(synchronous).build();
    }

    public static MasterProtos.IsBalancerEnabledRequest buildIsBalancerEnabledRequest() {
        return MasterProtos.IsBalancerEnabledRequest.newBuilder().build();
    }

    public static AdminProtos.ClearRegionBlockCacheRequest buildClearRegionBlockCacheRequest(List<RegionInfo> hris) {
        AdminProtos.ClearRegionBlockCacheRequest.Builder builder = AdminProtos.ClearRegionBlockCacheRequest.newBuilder();
        hris.forEach(hri -> builder.addRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, hri.getRegionName())));
        return builder.build();
    }

    public static MasterProtos.GetClusterStatusRequest buildGetClusterStatusRequest(EnumSet<ClusterMetrics.Option> options) {
        return MasterProtos.GetClusterStatusRequest.newBuilder().addAllOptions(ClusterMetricsBuilder.toOptions(options)).build();
    }

    public static MasterProtos.RunCatalogScanRequest buildCatalogScanRequest() {
        return MasterProtos.RunCatalogScanRequest.getDefaultInstance();
    }

    public static MasterProtos.EnableCatalogJanitorRequest buildEnableCatalogJanitorRequest(boolean enable) {
        return MasterProtos.EnableCatalogJanitorRequest.newBuilder().setEnable(enable).build();
    }

    public static MasterProtos.IsCatalogJanitorEnabledRequest buildIsCatalogJanitorEnabledRequest() {
        return MasterProtos.IsCatalogJanitorEnabledRequest.getDefaultInstance();
    }

    public static MasterProtos.RunCleanerChoreRequest buildRunCleanerChoreRequest() {
        return MasterProtos.RunCleanerChoreRequest.getDefaultInstance();
    }

    public static MasterProtos.SetCleanerChoreRunningRequest buildSetCleanerChoreRunningRequest(boolean on) {
        return MasterProtos.SetCleanerChoreRunningRequest.newBuilder().setOn(on).build();
    }

    public static MasterProtos.IsCleanerChoreEnabledRequest buildIsCleanerChoreEnabledRequest() {
        return MasterProtos.IsCleanerChoreEnabledRequest.getDefaultInstance();
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdRequest buildGetLastFlushedSequenceIdRequest(byte[] regionName) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdRequest.newBuilder().setRegionName(UnsafeByteOperations.unsafeWrap(regionName)).build();
    }

    public static AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfo(RegionInfo region, List<ServerName> favoredNodes, long openProcId) {
        AdminProtos.OpenRegionRequest.RegionOpenInfo.Builder builder = AdminProtos.OpenRegionRequest.RegionOpenInfo.newBuilder();
        builder.setRegion(ProtobufUtil.toRegionInfo(region));
        if (favoredNodes != null) {
            for (ServerName server : favoredNodes) {
                builder.addFavoredNodes(ProtobufUtil.toServerName(server));
            }
        }
        builder.setOpenProcId(openProcId);
        return builder.build();
    }

    public static MasterProtos.NormalizeRequest buildNormalizeRequest(NormalizeTableFilterParams ntfp) {
        MasterProtos.NormalizeRequest.Builder builder = MasterProtos.NormalizeRequest.newBuilder();
        if (ntfp.getTableNames() != null) {
            builder.addAllTableNames(ProtobufUtil.toProtoTableNameList(ntfp.getTableNames()));
        }
        if (ntfp.getRegex() != null) {
            builder.setRegex(ntfp.getRegex());
        }
        if (ntfp.getNamespace() != null) {
            builder.setNamespace(ntfp.getNamespace());
        }
        return builder.build();
    }

    public static MasterProtos.IsNormalizerEnabledRequest buildIsNormalizerEnabledRequest() {
        return MasterProtos.IsNormalizerEnabledRequest.newBuilder().build();
    }

    public static MasterProtos.SetNormalizerRunningRequest buildSetNormalizerRunningRequest(boolean on) {
        return MasterProtos.SetNormalizerRunningRequest.newBuilder().setOn(on).build();
    }

    public static MasterProtos.IsSplitOrMergeEnabledRequest buildIsSplitOrMergeEnabledRequest(MasterSwitchType switchType) {
        MasterProtos.IsSplitOrMergeEnabledRequest.Builder builder = MasterProtos.IsSplitOrMergeEnabledRequest.newBuilder();
        builder.setSwitchType(RequestConverter.convert(switchType));
        return builder.build();
    }

    public static MasterProtos.SetSplitOrMergeEnabledRequest buildSetSplitOrMergeEnabledRequest(boolean enabled, boolean synchronous, MasterSwitchType ... switchTypes) {
        MasterProtos.SetSplitOrMergeEnabledRequest.Builder builder = MasterProtos.SetSplitOrMergeEnabledRequest.newBuilder();
        builder.setEnabled(enabled);
        builder.setSynchronous(synchronous);
        for (MasterSwitchType switchType : switchTypes) {
            builder.addSwitchTypes(RequestConverter.convert(switchType));
        }
        return builder.build();
    }

    private static MasterProtos.MasterSwitchType convert(MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return MasterProtos.MasterSwitchType.SPLIT;
            }
            case MERGE: {
                return MasterProtos.MasterSwitchType.MERGE;
            }
        }
        throw new UnsupportedOperationException("Unsupport switch type:" + (Object)((Object)switchType));
    }

    public static ReplicationProtos.AddReplicationPeerRequest buildAddReplicationPeerRequest(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        ReplicationProtos.AddReplicationPeerRequest.Builder builder = ReplicationProtos.AddReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        builder.setPeerConfig(ReplicationPeerConfigUtil.convert(peerConfig));
        ReplicationProtos.ReplicationState.Builder stateBuilder = ReplicationProtos.ReplicationState.newBuilder();
        stateBuilder.setState(enabled ? ReplicationProtos.ReplicationState.State.ENABLED : ReplicationProtos.ReplicationState.State.DISABLED);
        builder.setPeerState(stateBuilder.build());
        return builder.build();
    }

    public static ReplicationProtos.RemoveReplicationPeerRequest buildRemoveReplicationPeerRequest(String peerId) {
        ReplicationProtos.RemoveReplicationPeerRequest.Builder builder = ReplicationProtos.RemoveReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.EnableReplicationPeerRequest buildEnableReplicationPeerRequest(String peerId) {
        ReplicationProtos.EnableReplicationPeerRequest.Builder builder = ReplicationProtos.EnableReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.DisableReplicationPeerRequest buildDisableReplicationPeerRequest(String peerId) {
        ReplicationProtos.DisableReplicationPeerRequest.Builder builder = ReplicationProtos.DisableReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.GetReplicationPeerConfigRequest buildGetReplicationPeerConfigRequest(String peerId) {
        ReplicationProtos.GetReplicationPeerConfigRequest.Builder builder = ReplicationProtos.GetReplicationPeerConfigRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.UpdateReplicationPeerConfigRequest buildUpdateReplicationPeerConfigRequest(String peerId, ReplicationPeerConfig peerConfig) {
        ReplicationProtos.UpdateReplicationPeerConfigRequest.Builder builder = ReplicationProtos.UpdateReplicationPeerConfigRequest.newBuilder();
        builder.setPeerId(peerId);
        builder.setPeerConfig(ReplicationPeerConfigUtil.convert(peerConfig));
        return builder.build();
    }

    public static ReplicationProtos.ListReplicationPeersRequest buildListReplicationPeersRequest(Pattern pattern) {
        ReplicationProtos.ListReplicationPeersRequest.Builder builder = ReplicationProtos.ListReplicationPeersRequest.newBuilder();
        if (pattern != null) {
            builder.setRegex(pattern.toString());
        }
        return builder.build();
    }

    public static MasterProtos.CreateNamespaceRequest buildCreateNamespaceRequest(NamespaceDescriptor descriptor) {
        MasterProtos.CreateNamespaceRequest.Builder builder = MasterProtos.CreateNamespaceRequest.newBuilder();
        builder.setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor));
        return builder.build();
    }

    public static MasterProtos.ModifyNamespaceRequest buildModifyNamespaceRequest(NamespaceDescriptor descriptor) {
        MasterProtos.ModifyNamespaceRequest.Builder builder = MasterProtos.ModifyNamespaceRequest.newBuilder();
        builder.setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor));
        return builder.build();
    }

    public static MasterProtos.DeleteNamespaceRequest buildDeleteNamespaceRequest(String name) {
        MasterProtos.DeleteNamespaceRequest.Builder builder = MasterProtos.DeleteNamespaceRequest.newBuilder();
        builder.setNamespaceName(name);
        return builder.build();
    }

    public static MasterProtos.GetNamespaceDescriptorRequest buildGetNamespaceDescriptorRequest(String name) {
        MasterProtos.GetNamespaceDescriptorRequest.Builder builder = MasterProtos.GetNamespaceDescriptorRequest.newBuilder();
        builder.setNamespaceName(name);
        return builder.build();
    }

    public static AdminProtos.ClearCompactionQueuesRequest buildClearCompactionQueuesRequest(Set<String> queues) {
        AdminProtos.ClearCompactionQueuesRequest.Builder builder = AdminProtos.ClearCompactionQueuesRequest.newBuilder();
        for (String name : queues) {
            builder.addQueueName(name);
        }
        return builder.build();
    }

    public static MasterProtos.ClearDeadServersRequest buildClearDeadServersRequest(Collection<ServerName> deadServers) {
        MasterProtos.ClearDeadServersRequest.Builder builder = MasterProtos.ClearDeadServersRequest.newBuilder();
        for (ServerName server : deadServers) {
            builder.addServerName(ProtobufUtil.toServerName(server));
        }
        return builder.build();
    }

    public static QuotaProtos.GetSpaceQuotaRegionSizesRequest buildGetSpaceQuotaRegionSizesRequest() {
        return QuotaProtos.GetSpaceQuotaRegionSizesRequest.getDefaultInstance();
    }

    public static QuotaProtos.GetSpaceQuotaSnapshotsRequest buildGetSpaceQuotaSnapshotsRequest() {
        return QuotaProtos.GetSpaceQuotaSnapshotsRequest.getDefaultInstance();
    }

    public static QuotaProtos.GetQuotaStatesRequest buildGetQuotaStatesRequest() {
        return QuotaProtos.GetQuotaStatesRequest.getDefaultInstance();
    }

    public static MasterProtos.DecommissionRegionServersRequest buildDecommissionRegionServersRequest(List<ServerName> servers, boolean offload) {
        return MasterProtos.DecommissionRegionServersRequest.newBuilder().addAllServerName(RequestConverter.toProtoServerNames(servers)).setOffload(offload).build();
    }

    public static MasterProtos.RecommissionRegionServerRequest buildRecommissionRegionServerRequest(ServerName server, List<byte[]> encodedRegionNames) {
        MasterProtos.RecommissionRegionServerRequest.Builder builder = MasterProtos.RecommissionRegionServerRequest.newBuilder();
        if (encodedRegionNames != null) {
            for (byte[] name : encodedRegionNames) {
                builder.addRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, name));
            }
        }
        return builder.setServerName(ProtobufUtil.toServerName(server)).build();
    }

    private static List<HBaseProtos.ServerName> toProtoServerNames(List<ServerName> servers) {
        ArrayList<HBaseProtos.ServerName> pbServers = new ArrayList<HBaseProtos.ServerName>(servers.size());
        for (ServerName server : servers) {
            pbServers.add(ProtobufUtil.toServerName(server));
        }
        return pbServers;
    }

    public static ReplicationProtos.TransitReplicationPeerSyncReplicationStateRequest buildTransitReplicationPeerSyncReplicationStateRequest(String peerId, SyncReplicationState state) {
        return ReplicationProtos.TransitReplicationPeerSyncReplicationStateRequest.newBuilder().setPeerId(peerId).setSyncReplicationState(ReplicationPeerConfigUtil.toSyncReplicationState(state)).build();
    }

    public static MasterProtos.AssignsRequest toAssignRegionsRequest(List<String> encodedRegionNames, boolean override) {
        MasterProtos.AssignsRequest.Builder b = MasterProtos.AssignsRequest.newBuilder();
        return b.addAllRegion(RequestConverter.toEncodedRegionNameRegionSpecifiers(encodedRegionNames)).setOverride(override).build();
    }

    public static MasterProtos.UnassignsRequest toUnassignRegionsRequest(List<String> encodedRegionNames, boolean override) {
        MasterProtos.UnassignsRequest.Builder b = MasterProtos.UnassignsRequest.newBuilder();
        return b.addAllRegion(RequestConverter.toEncodedRegionNameRegionSpecifiers(encodedRegionNames)).setOverride(override).build();
    }

    public static MasterProtos.ScheduleServerCrashProcedureRequest toScheduleServerCrashProcedureRequest(List<ServerName> serverNames) {
        MasterProtos.ScheduleServerCrashProcedureRequest.Builder builder = MasterProtos.ScheduleServerCrashProcedureRequest.newBuilder();
        serverNames.stream().map(ProtobufUtil::toServerName).forEach(sn -> builder.addServerName((HBaseProtos.ServerName)sn));
        return builder.build();
    }

    private static List<HBaseProtos.RegionSpecifier> toEncodedRegionNameRegionSpecifiers(List<String> encodedRegionNames) {
        return encodedRegionNames.stream().map(r -> RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, Bytes.toBytes(r))).collect(Collectors.toList());
    }

    public static MasterProtos.SetSnapshotCleanupRequest buildSetSnapshotCleanupRequest(boolean enabled, boolean synchronous) {
        return MasterProtos.SetSnapshotCleanupRequest.newBuilder().setEnabled(enabled).setSynchronous(synchronous).build();
    }

    public static MasterProtos.IsSnapshotCleanupEnabledRequest buildIsSnapshotCleanupEnabledRequest() {
        return MasterProtos.IsSnapshotCleanupEnabledRequest.newBuilder().build();
    }

    public static HBaseProtos.LogRequest buildSlowLogResponseRequest(Map<String, Object> filterParams, int limit, String logType) {
        AdminProtos.SlowLogResponseRequest.Builder builder = AdminProtos.SlowLogResponseRequest.newBuilder();
        builder.setLimit(limit);
        if (logType.equals("SLOW_LOG")) {
            builder.setLogType(AdminProtos.SlowLogResponseRequest.LogType.SLOW_LOG);
        } else if (logType.equals("LARGE_LOG")) {
            builder.setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG);
        }
        boolean filterByAnd = false;
        if (MapUtils.isNotEmpty(filterParams)) {
            String filterByOperator;
            String userName;
            String tableName;
            String regionName;
            String clientAddress;
            if (filterParams.containsKey("clientAddress") && StringUtils.isNotEmpty(clientAddress = (String)filterParams.get("clientAddress"))) {
                builder.setClientAddress(clientAddress);
            }
            if (filterParams.containsKey("regionName") && StringUtils.isNotEmpty(regionName = (String)filterParams.get("regionName"))) {
                builder.setRegionName(regionName);
            }
            if (filterParams.containsKey("tableName") && StringUtils.isNotEmpty(tableName = (String)filterParams.get("tableName"))) {
                builder.setTableName(tableName);
            }
            if (filterParams.containsKey("userName") && StringUtils.isNotEmpty(userName = (String)filterParams.get("userName"))) {
                builder.setUserName(userName);
            }
            if (filterParams.containsKey("filterByOperator") && StringUtils.isNotEmpty(filterByOperator = (String)filterParams.get("filterByOperator")) && filterByOperator.toUpperCase().equals("AND")) {
                filterByAnd = true;
            }
        }
        if (filterByAnd) {
            builder.setFilterByOperator(AdminProtos.SlowLogResponseRequest.FilterByOperator.AND);
        } else {
            builder.setFilterByOperator(AdminProtos.SlowLogResponseRequest.FilterByOperator.OR);
        }
        AdminProtos.SlowLogResponseRequest slowLogResponseRequest = builder.build();
        return HBaseProtos.LogRequest.newBuilder().setLogClassName(slowLogResponseRequest.getClass().getName()).setLogMessage(slowLogResponseRequest.toByteString()).build();
    }

    public static AdminProtos.ClearSlowLogResponseRequest buildClearSlowLogResponseRequest() {
        return AdminProtos.ClearSlowLogResponseRequest.newBuilder().build();
    }

    public static RSGroupAdminProtos.MoveServersRequest buildMoveServersRequest(Set<Address> servers, String targetGroup) {
        HashSet<HBaseProtos.ServerName> hostPorts = Sets.newHashSet();
        for (Address el : servers) {
            hostPorts.add(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        return RSGroupAdminProtos.MoveServersRequest.newBuilder().setTargetGroup(targetGroup).addAllServers(hostPorts).build();
    }

    public static RSGroupAdminProtos.RemoveServersRequest buildRemoveServersRequest(Set<Address> servers) {
        HashSet<HBaseProtos.ServerName> hostPorts = Sets.newHashSet();
        for (Address el : servers) {
            hostPorts.add(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        return RSGroupAdminProtos.RemoveServersRequest.newBuilder().addAllServers(hostPorts).build();
    }

    public static MasterProtos.FlushTableRequest buildFlushTableRequest(TableName tableName, List<byte[]> columnFamilies, long nonceGroup, long nonce) {
        MasterProtos.FlushTableRequest.Builder builder = MasterProtos.FlushTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        if (!columnFamilies.isEmpty()) {
            for (byte[] columnFamily : columnFamilies) {
                builder.addColumnFamily(UnsafeByteOperations.unsafeWrap(columnFamily));
            }
        }
        return builder.setNonceGroup(nonceGroup).setNonce(nonce).build();
    }
}

