/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.zookeeper.MetricsZooKeeperSource;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsZooKeeperSourceImpl
extends BaseSourceImpl
implements MetricsZooKeeperSource {
    private final MutableGaugeLong authFailedFailedOpCount = this.getMetricsRegistry().newGauge("AUTHFAILED Exception", "Number of failed ops due to an AUTHFAILED exception,", 0L);
    private final MutableGaugeLong connectionLossFailedOpCount = this.getMetricsRegistry().newGauge("CONNECTIONLOSS Exception", "Number of failed ops due to a CONNECTIONLOSS exception.", 0L);
    private final MutableGaugeLong dataInconsistencyFailedOpCount = this.getMetricsRegistry().newGauge("DATAINCONSISTENCY Exception", "Number of failed ops due to a DATAINCONSISTENCY exception.", 0L);
    private final MutableGaugeLong invalidACLFailedOpCount = this.getMetricsRegistry().newGauge("INVALIDACL Exception", "Number of failed ops due to an INVALIDACL exception", 0L);
    private final MutableGaugeLong noAuthFailedOpCount = this.getMetricsRegistry().newGauge("NOAUTH Exception", "Number of failed ops due to a NOAUTH exception.", 0L);
    private final MutableGaugeLong operationTimeOutFailedOpCount = this.getMetricsRegistry().newGauge("OPERATIONTIMEOUT Exception", "Number of failed ops due to an OPERATIONTIMEOUT exception.", 0L);
    private final MutableGaugeLong runtimeInconsistencyFailedOpCount = this.getMetricsRegistry().newGauge("RUNTIMEINCONSISTENCY Exception", "Number of failed ops due to a RUNTIMEINCONSISTENCY exception.", 0L);
    private final MutableGaugeLong sessionExpiredFailedOpCount = this.getMetricsRegistry().newGauge("SESSIONEXPIRED Exception", "Number of failed ops due to a SESSIONEXPIRED exception.", 0L);
    private final MutableGaugeLong systemErrorFailedOpCount = this.getMetricsRegistry().newGauge("SYSTEMERROR Exception", "Number of failed ops due to a SYSTEMERROR exception.", 0L);
    private final MutableGaugeLong totalFailedZKCalls = this.getMetricsRegistry().newGauge("TotalFailedZKCalls", "Total number of failed ZooKeeper API Calls", 0L);
    private MutableHistogram readOpLatency = this.getMetricsRegistry().newHistogram("ReadOperationLatency", "Latency histogram for read operations.");
    private MutableHistogram writeOpLatency = this.getMetricsRegistry().newHistogram("WriteOperationLatency", "Latency histogram for write operations.");
    private MutableHistogram syncOpLatency = this.getMetricsRegistry().newHistogram("SyncOperationLatency", "Latency histogram for sync operations.");

    public MetricsZooKeeperSourceImpl() {
        this("ZOOKEEPER", "Metrics about ZooKeeper", "zookeeper", "ZooKeeper,sub=ZOOKEEPER");
    }

    public MetricsZooKeeperSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        super.getMetrics(metricsCollector, all);
        this.clearZKExceptionMetrics();
    }

    private void clearZKExceptionMetrics() {
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.authFailedFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.connectionLossFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.dataInconsistencyFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.invalidACLFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.noAuthFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.operationTimeOutFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.runtimeInconsistencyFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.sessionExpiredFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.systemErrorFailedOpCount);
        MetricsZooKeeperSourceImpl.clearMetricIfNotNull(this.totalFailedZKCalls);
    }

    private static void clearMetricIfNotNull(MutableGaugeLong metric) {
        if (metric != null) {
            metric.set(0L);
        }
    }

    @Override
    public void incrementAuthFailedCount() {
        this.authFailedFailedOpCount.incr();
    }

    @Override
    public void incrementConnectionLossCount() {
        this.connectionLossFailedOpCount.incr();
    }

    @Override
    public void incrementDataInconsistencyCount() {
        this.dataInconsistencyFailedOpCount.incr();
    }

    @Override
    public void incrementInvalidACLCount() {
        this.invalidACLFailedOpCount.incr();
    }

    @Override
    public void incrementNoAuthCount() {
        this.noAuthFailedOpCount.incr();
    }

    @Override
    public void incrementOperationTimeoutCount() {
        this.operationTimeOutFailedOpCount.incr();
    }

    @Override
    public void incrementRuntimeInconsistencyCount() {
        this.runtimeInconsistencyFailedOpCount.incr();
    }

    @Override
    public void incrementSessionExpiredCount() {
        this.sessionExpiredFailedOpCount.incr();
    }

    @Override
    public void incrementSystemErrorCount() {
        this.systemErrorFailedOpCount.incr();
    }

    @Override
    public void incrementTotalFailedZKCalls() {
        this.totalFailedZKCalls.incr();
    }

    @Override
    public void recordReadOperationLatency(long latency) {
        this.readOpLatency.add(latency);
    }

    @Override
    public void recordWriteOperationLatency(long latency) {
        this.writeOpLatency.add(latency);
    }

    @Override
    public void recordSyncOperationLatency(long latency) {
        this.syncOpLatency.add(latency);
    }
}

