/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MapReduceTests.class, SmallTests.class})
public class TestTableSplit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableSplit.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testHashCode() {
        TableSplit split1 = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location");
        TableSplit split2 = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location");
        Assert.assertEquals((Object)split1, (Object)split2);
        Assert.assertTrue((split1.hashCode() == split2.hashCode() ? 1 : 0) != 0);
        HashSet<TableSplit> set = new HashSet<TableSplit>(2);
        set.add(split1);
        set.add(split2);
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testHashCode_length() {
        TableSplit split1 = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location", 1984L);
        TableSplit split2 = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location", 1982L);
        Assert.assertEquals((Object)split1, (Object)split2);
        Assert.assertTrue((split1.hashCode() == split2.hashCode() ? 1 : 0) != 0);
        HashSet<TableSplit> set = new HashSet<TableSplit>(2);
        set.add(split1);
        set.add(split2);
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testLengthIsSerialized() throws Exception {
        TableSplit split1 = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location", 666L);
        TableSplit deserialized = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start2"), Bytes.toBytes((String)"row-end2"), "location1");
        ReflectionUtils.copy((Configuration)new Configuration(), (Object)split1, (Object)deserialized);
        Assert.assertEquals((long)666L, (long)deserialized.getLength());
    }

    @Test
    public void testToString() {
        TableSplit split = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location");
        String str = "Split(tablename=" + this.name.getMethodName() + ", startrow=row-start, endrow=row-end, regionLocation=location, regionname=)";
        Assert.assertEquals((Object)str, (Object)split.toString());
        split = new TableSplit(TableName.valueOf((String)this.name.getMethodName()), null, Bytes.toBytes((String)"row-start"), Bytes.toBytes((String)"row-end"), "location", "encoded-region-name", 1000L);
        str = "Split(tablename=" + this.name.getMethodName() + ", startrow=row-start, endrow=row-end, regionLocation=location, regionname=encoded-region-name)";
        Assert.assertEquals((Object)str, (Object)split.toString());
        split = new TableSplit(null, null, null, null);
        str = "Split(tablename=null, startrow=null, endrow=null, regionLocation=null, regionname=)";
        Assert.assertEquals((Object)str, (Object)split.toString());
        split = new TableSplit(null, null, null, null, null, null, 1000L);
        str = "Split(tablename=null, startrow=null, endrow=null, regionLocation=null, regionname=null)";
        Assert.assertEquals((Object)str, (Object)split.toString());
    }
}

