/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestExportSnapshotV1NoCluster;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestExportSnapshotV2NoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshotV2NoCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestExportSnapshotV2NoCluster.class);
    private HBaseCommonTestingUtil testUtil = new HBaseCommonTestingUtil();
    private Path testDir;
    private FileSystem fs;

    @Before
    public void before() throws Exception {
        this.fs = FileSystem.getLocal((Configuration)this.testUtil.getConfiguration());
        this.testDir = TestExportSnapshotV1NoCluster.setup(this.fs, this.testUtil);
        LOG.info("fs={}, testDir={}", (Object)this.fs, (Object)this.testDir);
        Assert.assertTrue((String)("FileSystem '" + this.fs + "' is not local"), (boolean)(this.fs instanceof LocalFileSystem));
    }

    @Test
    public void testSnapshotWithRefsExportFileSystemState() throws Exception {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(this.testUtil.getConfiguration(), this.testDir.getFileSystem(this.testUtil.getConfiguration()), this.testDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("tableWithRefsV2", "tableWithRefsV2");
        TestExportSnapshotV1NoCluster.testSnapshotWithRefsExportFileSystemState(this.fs, builder, this.testUtil, this.testDir);
    }
}

