/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyJob;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.TableBackupClient;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FullTableBackupClient
extends TableBackupClient {
    private static final Logger LOG = LoggerFactory.getLogger(FullTableBackupClient.class);

    public FullTableBackupClient() {
    }

    public FullTableBackupClient(Connection conn, String backupId, BackupRequest request) throws IOException {
        super(conn, backupId, request);
    }

    protected void snapshotCopy(BackupInfo backupInfo) throws Exception {
        LOG.info("Snapshot copy is starting.");
        backupInfo.setPhase(BackupInfo.BackupPhase.SNAPSHOTCOPY);
        BackupCopyJob copyService = BackupRestoreFactory.getBackupCopyJob(this.conf);
        float numOfSnapshots = backupInfo.getSnapshotNames().size();
        LOG.debug("There are " + (int)numOfSnapshots + " snapshots to be copied.");
        for (TableName table : backupInfo.getTables()) {
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("-snapshot");
            argsList.add(backupInfo.getSnapshotName(table));
            argsList.add("-copy-to");
            argsList.add(backupInfo.getTableBackupDir(table));
            if (backupInfo.getBandwidth() > -1L) {
                argsList.add("-bandwidth");
                argsList.add(String.valueOf(backupInfo.getBandwidth()));
            }
            if (backupInfo.getWorkers() > -1) {
                argsList.add("-mappers");
                argsList.add(String.valueOf(backupInfo.getWorkers()));
            }
            String[] args = argsList.toArray(new String[0]);
            String jobname = "Full-Backup_" + backupInfo.getBackupId() + "_" + table.getNameAsString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting snapshot copy job name to : " + jobname);
            }
            this.conf.set("mapreduce.job.name", jobname);
            LOG.debug("Copy snapshot " + args[1] + " to " + args[3]);
            int res = copyService.copy(backupInfo, this.backupManager, this.conf, BackupType.FULL, args);
            if (res != 0) {
                LOG.error("Exporting Snapshot " + args[1] + " failed with return code: " + res + ".");
                throw new IOException("Failed of exporting snapshot " + args[1] + " to " + args[3] + " with reason code " + res);
            }
            this.conf.unset("mapreduce.job.name");
            LOG.info("Snapshot copy " + args[1] + " finished.");
        }
    }

    @Override
    public void execute() throws IOException {
        try (Admin admin = this.conn.getAdmin();){
            boolean firstBackup;
            this.beginBackup(this.backupManager, this.backupInfo);
            String savedStartCode = this.backupManager.readBackupStartCode();
            boolean bl = firstBackup = savedStartCode == null || Long.parseLong(savedStartCode) == 0L;
            if (firstBackup) {
                this.backupManager.writeBackupStartCode(0L);
            }
            LOG.info("Execute roll log procedure for full backup ...");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("backupRoot", this.backupInfo.getBackupRootDir());
            admin.execProcedure("rolllog-proc", "rolllog", props);
            this.newTimestamps = this.backupManager.readRegionServerLastLogRollResult();
            this.backupInfo.setPhase(BackupInfo.BackupPhase.SNAPSHOT);
            for (TableName tableName : this.tableList) {
                String snapshotName = "snapshot_" + Long.toString(EnvironmentEdgeManager.currentTime()) + "_" + tableName.getNamespaceAsString() + "_" + tableName.getQualifierAsString();
                this.snapshotTable(admin, tableName, snapshotName);
                this.backupInfo.setSnapshotName(tableName, snapshotName);
            }
            LOG.debug("snapshot copy for " + this.backupId);
            this.snapshotCopy(this.backupInfo);
            this.backupManager.addIncrementalBackupTableSet(this.backupInfo.getTables());
            this.backupInfo.setState(BackupInfo.BackupState.COMPLETE);
            this.backupManager.writeRegionServerLogTimestamp(this.backupInfo.getTables(), this.newTimestamps);
            Map<TableName, Map<String, Long>> newTableSetTimestampMap = this.backupManager.readLogTimestampMap();
            this.backupInfo.setTableSetTimestampMap(newTableSetTimestampMap);
            Long newStartCode = BackupUtils.getMinValue(BackupUtils.getRSLogTimestampMins(newTableSetTimestampMap));
            this.backupManager.writeBackupStartCode(newStartCode);
            this.completeBackup(this.conn, this.backupInfo, this.backupManager, BackupType.FULL, this.conf);
        }
        catch (Exception e) {
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, "Unexpected BackupException : ", BackupType.FULL, this.conf);
            throw new IOException(e);
        }
    }

    protected void snapshotTable(Admin admin, TableName tableName, String snapshotName) throws IOException {
        int maxAttempts = this.conf.getInt("hbase.backup.attempts.max", 10);
        int pause = this.conf.getInt("hbase.backup.attempts.pause.ms", 10000);
        int attempts = 0;
        while (attempts++ < maxAttempts) {
            try {
                admin.snapshot(snapshotName, tableName);
                return;
            }
            catch (IOException ee) {
                LOG.warn("Snapshot attempt " + attempts + " failed for table " + tableName + ", sleeping for " + pause + "ms", (Throwable)ee);
                if (attempts >= maxAttempts) continue;
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw new IOException("Failed to snapshot table " + tableName);
    }
}

