/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseServerBase;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.NoopAccessChecker;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.OOMEChecker;
import org.apache.hadoop.hbase.util.ReservoirSample;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class HBaseRpcServicesBase<S extends HBaseServerBase<?>>
implements RegistryProtos.ClientMetaService.BlockingInterface,
AdminProtos.AdminService.BlockingInterface,
HBaseRPCErrorHandler,
PriorityFunction,
ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRpcServicesBase.class);
    public static final String CLIENT_BOOTSTRAP_NODE_LIMIT = "hbase.client.bootstrap.node.limit";
    public static final int DEFAULT_CLIENT_BOOTSTRAP_NODE_LIMIT = 10;
    protected final S server;
    protected final RpcServer rpcServer;
    private final InetSocketAddress isa;
    protected final PriorityFunction priority;
    private AccessChecker accessChecker;
    private ZKPermissionWatcher zkPermissionWatcher;

    protected HBaseRpcServicesBase(S server, String processName) throws IOException {
        RpcSchedulerFactory rpcSchedulerFactory;
        this.server = server;
        Configuration conf = ((HBaseServerBase)server).getConfiguration();
        try {
            rpcSchedulerFactory = this.getRpcSchedulerFactoryClass(conf).asSubclass(RpcSchedulerFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        String hostname = DNS.getHostname(conf, this.getDNSServerType());
        int port = conf.getInt(this.getPortConfigName(), this.getDefaultPort());
        InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
        InetSocketAddress bindAddress = new InetSocketAddress(this.getHostname(conf, hostname), port);
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.priority = this.createPriority();
        String name = processName + "/" + Address.fromParts(initialIsa.getHostName(), initialIsa.getPort()).toStringWithoutDomain();
        ((Thread)server).setName(name);
        ConnectionUtils.setServerSideHConnectionRetriesConfig(conf, name, LOG);
        boolean reservoirEnabled = conf.getBoolean("hbase.server.allocator.pool.enabled", this.defaultReservoirEnabled());
        try {
            this.rpcServer = RpcServerFactory.createRpcServer(server, name, this.getServices(), bindAddress, conf, rpcSchedulerFactory.create(conf, this, (Abortable)server), reservoirEnabled);
        }
        catch (BindException be) {
            throw new IOException(be.getMessage() + ". To switch ports use the '" + this.getPortConfigName() + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
        InetSocketAddress address = this.rpcServer.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = new InetSocketAddress(initialIsa.getHostName(), address.getPort());
        this.rpcServer.setErrorHandler(this);
    }

    protected abstract boolean defaultReservoirEnabled();

    protected abstract DNS.ServerType getDNSServerType();

    protected abstract String getHostname(Configuration var1, String var2);

    protected abstract String getPortConfigName();

    protected abstract int getDefaultPort();

    protected abstract PriorityFunction createPriority();

    protected abstract Class<?> getRpcSchedulerFactoryClass(Configuration var1);

    protected abstract List<RpcServer.BlockingServiceAndInterface> getServices();

    protected final void internalStart(ZKWatcher zkWatcher) {
        this.accessChecker = AccessChecker.isAuthorizationSupported(this.getConfiguration()) ? new AccessChecker(this.getConfiguration()) : new NoopAccessChecker(this.getConfiguration());
        this.zkPermissionWatcher = new ZKPermissionWatcher(zkWatcher, this.accessChecker.getAuthManager(), this.getConfiguration());
        try {
            this.zkPermissionWatcher.start();
        }
        catch (KeeperException e) {
            LOG.error("ZooKeeper permission watcher initialization failed", (Throwable)e);
        }
        this.rpcServer.start();
    }

    protected final void requirePermission(String request, Permission.Action perm) throws IOException {
        if (this.accessChecker != null) {
            this.accessChecker.requirePermission(RpcServer.getRequestUser().orElse(null), request, null, perm);
        }
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public ZKPermissionWatcher getZkPermissionWatcher() {
        return this.zkPermissionWatcher;
    }

    protected final void internalStop() {
        if (this.zkPermissionWatcher != null) {
            this.zkPermissionWatcher.close();
        }
        this.rpcServer.stop();
    }

    public Configuration getConfiguration() {
        return ((HBaseServerBase)this.server).getConfiguration();
    }

    public S getServer() {
        return this.server;
    }

    public InetSocketAddress getSocketAddress() {
        return this.isa;
    }

    public RpcServerInterface getRpcServer() {
        return this.rpcServer;
    }

    public RpcScheduler getRpcScheduler() {
        return this.rpcServer.getScheduler();
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        return this.priority.getPriority(header, param, user);
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        return this.priority.getDeadline(header, param);
    }

    @Override
    public boolean checkOOME(Throwable e) {
        return OOMEChecker.exitIfOOME(e, this.getClass().getSimpleName());
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.rpcServer.onConfigurationChange(conf);
    }

    @Override
    public RegistryProtos.GetClusterIdResponse getClusterId(RpcController controller, RegistryProtos.GetClusterIdRequest request) throws ServiceException {
        return RegistryProtos.GetClusterIdResponse.newBuilder().setClusterId(this.server.getClusterId()).build();
    }

    @Override
    public RegistryProtos.GetActiveMasterResponse getActiveMaster(RpcController controller, RegistryProtos.GetActiveMasterRequest request) throws ServiceException {
        RegistryProtos.GetActiveMasterResponse.Builder builder = RegistryProtos.GetActiveMasterResponse.newBuilder();
        this.server.getActiveMaster().ifPresent(name -> builder.setServerName(ProtobufUtil.toServerName(name)));
        return builder.build();
    }

    @Override
    public RegistryProtos.GetMastersResponse getMasters(RpcController controller, RegistryProtos.GetMastersRequest request) throws ServiceException {
        RegistryProtos.GetMastersResponse.Builder builder = RegistryProtos.GetMastersResponse.newBuilder();
        this.server.getActiveMaster().ifPresent(activeMaster -> builder.addMasterServers(RegistryProtos.GetMastersResponseEntry.newBuilder().setServerName(ProtobufUtil.toServerName(activeMaster)).setIsActive(true)));
        this.server.getBackupMasters().forEach(backupMaster -> builder.addMasterServers(RegistryProtos.GetMastersResponseEntry.newBuilder().setServerName(ProtobufUtil.toServerName(backupMaster)).setIsActive(false)));
        return builder.build();
    }

    @Override
    public RegistryProtos.GetMetaRegionLocationsResponse getMetaRegionLocations(RpcController controller, RegistryProtos.GetMetaRegionLocationsRequest request) throws ServiceException {
        RegistryProtos.GetMetaRegionLocationsResponse.Builder builder = RegistryProtos.GetMetaRegionLocationsResponse.newBuilder();
        this.server.getMetaLocations().forEach(location -> builder.addMetaLocations(ProtobufUtil.toRegionLocation(location)));
        return builder.build();
    }

    @Override
    public final RegistryProtos.GetBootstrapNodesResponse getBootstrapNodes(RpcController controller, RegistryProtos.GetBootstrapNodesRequest request) throws ServiceException {
        int maxNodeCount = ((HBaseServerBase)this.server).getConfiguration().getInt(CLIENT_BOOTSTRAP_NODE_LIMIT, 10);
        ReservoirSample<ServerName> sample = new ReservoirSample<ServerName>(maxNodeCount);
        sample.add(this.server.getBootstrapNodes());
        RegistryProtos.GetBootstrapNodesResponse.Builder builder = RegistryProtos.GetBootstrapNodesResponse.newBuilder();
        sample.getSamplingResult().stream().map(ProtobufUtil::toServerName).forEach(builder::addServerName);
        return builder.build();
    }

    @Override
    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        try {
            this.requirePermission("updateConfiguration", Permission.Action.ADMIN);
            ((HBaseServerBase)this.server).updateConfiguration();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return AdminProtos.UpdateConfigurationResponse.getDefaultInstance();
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.ClearSlowLogResponses clearSlowLogsResponses(RpcController controller, AdminProtos.ClearSlowLogResponseRequest request) throws ServiceException {
        try {
            this.requirePermission("clearSlowLogsResponses", Permission.Action.ADMIN);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        NamedQueueRecorder namedQueueRecorder = ((HBaseServerBase)this.server).getNamedQueueRecorder();
        boolean slowLogsCleaned = Optional.ofNullable(namedQueueRecorder).map(queueRecorder -> queueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG)).orElse(false);
        AdminProtos.ClearSlowLogResponses clearSlowLogResponses = AdminProtos.ClearSlowLogResponses.newBuilder().setIsCleaned(slowLogsCleaned).build();
        return clearSlowLogResponses;
    }

    private List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request, NamedQueueRecorder namedQueueRecorder) {
        if (namedQueueRecorder == null) {
            return Collections.emptyList();
        }
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(0);
        namedQueueGetRequest.setSlowLogResponseRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = namedQueueGetResponse != null ? namedQueueGetResponse.getSlowLogPayloads() : Collections.emptyList();
        return slowLogPayloads;
    }

    @Override
    @QosPriority(priority=100)
    public HBaseProtos.LogEntry getLogEntries(RpcController controller, HBaseProtos.LogRequest request) throws ServiceException {
        try {
            String logClassName = request.getLogClassName();
            Class<Message> logClass = Class.forName(logClassName).asSubclass(Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("SlowLogResponseRequest")) {
                AdminProtos.SlowLogResponseRequest slowLogResponseRequest = (AdminProtos.SlowLogResponseRequest)method.invoke(null, request.getLogMessage());
                NamedQueueRecorder namedQueueRecorder = ((HBaseServerBase)this.server).getNamedQueueRecorder();
                List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(slowLogResponseRequest, namedQueueRecorder);
                AdminProtos.SlowLogResponses slowLogResponses = AdminProtos.SlowLogResponses.newBuilder().addAllSlowLogPayloads(slowLogPayloads).build();
                return HBaseProtos.LogEntry.newBuilder().setLogClassName(slowLogResponses.getClass().getName()).setLogMessage(slowLogResponses.toByteString()).build();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Error while retrieving log entries.", (Throwable)e);
            throw new ServiceException(e);
        }
        throw new ServiceException("Invalid request params");
    }
}

