/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionReplicationRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncRegionServerAdmin;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.BootstrapNodeProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.security.token.Token;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncClusterConnectionImpl
extends AsyncConnectionImpl
implements AsyncClusterConnection {
    public AsyncClusterConnectionImpl(Configuration conf, ConnectionRegistry registry, String clusterId, SocketAddress localAddress, User user) {
        super(conf, registry, clusterId, localAddress, user, Collections.emptyMap());
    }

    @Override
    public NonceGenerator getNonceGenerator() {
        return super.getNonceGenerator();
    }

    @Override
    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    @Override
    public AsyncRegionServerAdmin getRegionServerAdmin(ServerName serverName) {
        return new AsyncRegionServerAdmin(serverName, this);
    }

    @Override
    public CompletableFuture<AdminProtos.FlushRegionResponse> flush(byte[] regionName, boolean writeFlushWALMarker) {
        RawAsyncHBaseAdmin admin = (RawAsyncHBaseAdmin)this.getAdmin();
        return admin.flushRegionInternal(regionName, null, writeFlushWALMarker);
    }

    @Override
    public CompletableFuture<RegionLocations> getRegionLocations(TableName tableName, byte[] row, boolean reload) {
        return this.getLocator().getRegionLocations(tableName, row, RegionLocateType.CURRENT, reload, -1L);
    }

    @Override
    public CompletableFuture<String> prepareBulkLoad(TableName tableName) {
        return this.callerFactory.single().table(tableName).row(HConstants.EMPTY_START_ROW).action((controller, loc, stub) -> ConnectionUtils.call(controller, loc, stub, tableName, (rn, tn) -> {
            HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, rn);
            return ClientProtos.PrepareBulkLoadRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tn)).setRegion(region).build();
        }, (s2, c, req, done) -> s2.prepareBulkLoad(c, (ClientProtos.PrepareBulkLoadRequest)req, done), (c, resp) -> resp.getBulkToken())).call();
    }

    @Override
    public CompletableFuture<Boolean> bulkLoad(TableName tableName, List<Pair<byte[], String>> familyPaths, byte[] row, boolean assignSeqNum, Token<?> userToken, String bulkToken, boolean copyFiles, List<String> clusterIds, boolean replicate) {
        return this.callerFactory.single().table(tableName).row(row).action((controller, loc, stub) -> ConnectionUtils.call(controller, loc, stub, null, (rn, nil) -> RequestConverter.buildBulkLoadHFileRequest(familyPaths, rn, assignSeqNum, userToken, bulkToken, copyFiles, clusterIds, replicate), (s2, c, req, done) -> s2.bulkLoadHFile(c, (ClientProtos.BulkLoadHFileRequest)req, done), (c, resp) -> resp.getLoaded())).call();
    }

    @Override
    public CompletableFuture<Void> cleanupBulkLoad(TableName tableName, String bulkToken) {
        return this.callerFactory.single().table(tableName).row(HConstants.EMPTY_START_ROW).action((controller, loc, stub) -> ConnectionUtils.call(controller, loc, stub, bulkToken, (rn, bt) -> {
            HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, rn);
            return ClientProtos.CleanupBulkLoadRequest.newBuilder().setRegion(region).setBulkToken((String)bt).build();
        }, (s2, c, req, done) -> s2.cleanupBulkLoad(c, (ClientProtos.CleanupBulkLoadRequest)req, done), (c, resp) -> null)).call();
    }

    @Override
    public CompletableFuture<List<ServerName>> getLiveRegionServers(MasterAddressTracker masterAddrTracker, int count) {
        CompletableFuture<List<ServerName>> future = new CompletableFuture<List<ServerName>>();
        RegionServerStatusProtos.RegionServerStatusService.Stub stub = RegionServerStatusProtos.RegionServerStatusService.newStub(this.rpcClient.createRpcChannel(masterAddrTracker.getMasterAddress(), this.user, this.rpcTimeout));
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        stub.getLiveRegionServers(controller, RegionServerStatusProtos.GetLiveRegionServersRequest.newBuilder().setCount(count).build(), resp -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp.getServerList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<ServerName>> getAllBootstrapNodes(ServerName regionServer) {
        CompletableFuture<List<ServerName>> future = new CompletableFuture<List<ServerName>>();
        BootstrapNodeProtos.BootstrapNodeService.Stub stub = BootstrapNodeProtos.BootstrapNodeService.newStub(this.rpcClient.createRpcChannel(regionServer, this.user, this.rpcTimeout));
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        stub.getAllBootstrapNodes(controller, BootstrapNodeProtos.GetAllBootstrapNodesRequest.getDefaultInstance(), resp -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp.getNodeList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> replicate(RegionInfo replica, List<WAL.Entry> entries, int retries, long rpcTimeoutNs, long operationTimeoutNs) {
        return new AsyncRegionReplicationRetryingCaller(RETRY_TIMER, this, ConnectionUtils.retries2Attempts(retries), rpcTimeoutNs, operationTimeoutNs, replica, entries).call();
    }
}

