/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.AsyncClusterConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.protobuf.ReplicationProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AsyncRegionReplicationRetryingCaller
extends AsyncRpcRetryingCaller<Void> {
    private final RegionInfo replica;
    private final WAL.Entry[] entries;
    private boolean useReplay;

    public AsyncRegionReplicationRetryingCaller(HashedWheelTimer retryTimer, AsyncClusterConnectionImpl conn, int maxAttempts, long rpcTimeoutNs, long operationTimeoutNs, RegionInfo replica, List<WAL.Entry> entries) {
        super(retryTimer, conn, ConnectionUtils.getPriority(replica.getTable()), conn.connConf.getPauseNs(), conn.connConf.getPauseNsForServerOverloaded(), maxAttempts, operationTimeoutNs, rpcTimeoutNs, conn.connConf.getStartLogErrorsCnt(), Collections.emptyMap());
        this.replica = replica;
        this.entries = entries.toArray(new WAL.Entry[0]);
    }

    @Override
    protected Throwable preProcessError(Throwable error) {
        if (error instanceof DoNotRetryIOException && error.getCause() instanceof UnsupportedOperationException) {
            this.useReplay = true;
            return error.getCause();
        }
        return error;
    }

    private void onComplete(HRegionLocation loc) {
        if (this.controller.failed()) {
            this.onError(this.controller.getFailed(), () -> "Call to " + loc.getServerName() + " for " + this.replica + " failed", err -> this.conn.getLocator().updateCachedLocationOnError(loc, (Throwable)err));
        } else {
            this.future.complete(null);
        }
    }

    private void call(HRegionLocation loc) {
        AdminProtos.AdminService.Interface stub;
        try {
            stub = this.conn.getAdminStub(loc.getServerName());
        }
        catch (IOException e) {
            this.onError(e, () -> "Get async admin stub to " + loc.getServerName() + " for " + this.replica + " failed", err -> this.conn.getLocator().updateCachedLocationOnError(loc, (Throwable)err));
            return;
        }
        Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> pair = ReplicationProtobufUtil.buildReplicateWALEntryRequest(this.entries, this.replica.getEncodedNameAsBytes(), null, null, null);
        this.resetCallTimeout();
        this.controller.setCellScanner(pair.getSecond());
        if (this.useReplay) {
            stub.replay(this.controller, pair.getFirst(), r -> this.onComplete(loc));
        } else {
            stub.replicateToReplica(this.controller, pair.getFirst(), r -> this.onComplete(loc));
        }
    }

    @Override
    protected void doCall() {
        long locateTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            locateTimeoutNs = this.remainingTimeNs();
            if (locateTimeoutNs <= 0L) {
                this.completeExceptionally();
                return;
            }
        } else {
            locateTimeoutNs = -1L;
        }
        FutureUtils.addListener(this.conn.getLocator().getRegionLocation(this.replica.getTable(), this.replica.getStartKey(), this.replica.getReplicaId(), RegionLocateType.CURRENT, locateTimeoutNs), (loc, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Locate " + this.replica + " failed", err -> {});
                return;
            }
            this.call((HRegionLocation)loc);
        });
    }
}

