/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class MultiRowMutationEndpoint
extends MultiRowMutationProtos.MultiRowMutationService
implements RegionCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HRegion.class);
    private RegionCoprocessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mutateRows(RpcController controller, MultiRowMutationProtos.MutateRowsRequest request, RpcCallback<MultiRowMutationProtos.MutateRowsResponse> done) {
        boolean matches;
        block16: {
            matches = true;
            ArrayList<Region.RowLock> rowLocks = null;
            try {
                TreeSet<byte[]> rowsToLock = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                List<ClientProtos.MutationProto> mutateRequestList = request.getMutationRequestList();
                ArrayList<Mutation> mutations = new ArrayList<Mutation>(mutateRequestList.size());
                for (ClientProtos.MutationProto m3 : mutateRequestList) {
                    mutations.add(ProtobufUtil.toMutation(m3));
                }
                Region region = this.env.getRegion();
                RegionInfo regionInfo = region.getRegionInfo();
                for (Mutation m4 : mutations) {
                    if (!HRegion.rowIsInRange(regionInfo, m4.getRow())) {
                        String msg = "Requested row out of range '" + Bytes.toStringBinary(m4.getRow()) + "'";
                        if (rowsToLock.isEmpty()) {
                            throw new WrongRegionException(msg);
                        }
                        throw new DoNotRetryIOException(msg);
                    }
                    rowsToLock.add(m4.getRow());
                }
                if (request.getConditionCount() > 0) {
                    rowLocks = new ArrayList<Region.RowLock>();
                    for (ClientProtos.Condition condition : request.getConditionList()) {
                        rowsToLock.add(condition.getRow().toByteArray());
                    }
                    Iterator<Object> iterator = rowsToLock.iterator();
                    while (iterator.hasNext()) {
                        byte[] row = (byte[])iterator.next();
                        try {
                            Region.RowLock rowLock = region.getRowLock(row, false);
                            rowLocks.add(rowLock);
                        }
                        catch (IOException ioe) {
                            LOGGER.warn("Failed getting lock, row={}, in region {}", new Object[]{Bytes.toStringBinary(row), this, ioe});
                            throw ioe;
                        }
                    }
                    for (ClientProtos.Condition condition : request.getConditionList()) {
                        if (this.matches(region, condition)) continue;
                        matches = false;
                        break;
                    }
                }
                if (!matches) break block16;
                long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
                long nonce = request.hasNonce() ? request.getNonce() : 0L;
                region.mutateRowsWithLocks(mutations, (Collection<byte[]>)rowsToLock, nonceGroup, nonce);
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException(controller, e);
            }
            finally {
                if (rowLocks == null) break block16;
                for (Region.RowLock rowLock : rowLocks) {
                    rowLock.release();
                }
            }
        }
        done.run(MultiRowMutationProtos.MutateRowsResponse.newBuilder().setProcessed(matches).build());
    }

    private boolean matches(Region region, ClientProtos.Condition condition) throws IOException {
        byte[] row = condition.getRow().toByteArray();
        Filter filter = null;
        byte[] family = null;
        byte[] qualifier = null;
        CompareOperator op = null;
        ByteArrayComparable comparator = null;
        if (condition.hasFilter()) {
            filter = ProtobufUtil.toFilter(condition.getFilter());
        } else {
            family = condition.getFamily().toByteArray();
            qualifier = condition.getQualifier().toByteArray();
            op = CompareOperator.valueOf(condition.getCompareType().name());
            comparator = ProtobufUtil.toComparator(condition.getComparator());
        }
        TimeRange timeRange = condition.hasTimeRange() ? ProtobufUtil.toTimeRange(condition.getTimeRange()) : TimeRange.allTime();
        Get get = new Get(row);
        if (family != null) {
            this.checkFamily(region, family);
            get.addColumn(family, qualifier);
        }
        if (filter != null) {
            get.setFilter(filter);
        }
        if (timeRange != null) {
            get.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        boolean matches = false;
        try (RegionScanner scanner = region.getScanner(new Scan(get));){
            ArrayList<Cell> result = new ArrayList<Cell>();
            scanner.next(result);
            if (filter != null) {
                if (!result.isEmpty()) {
                    matches = true;
                }
            } else {
                boolean valueIsNull;
                boolean bl = valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                if (result.isEmpty() && valueIsNull) {
                    matches = true;
                } else if (result.size() > 0 && ((Cell)result.get(0)).getValueLength() == 0 && valueIsNull) {
                    matches = true;
                } else if (result.size() == 1 && !valueIsNull) {
                    Cell kv = (Cell)result.get(0);
                    int compareResult = PrivateCellUtil.compareValue(kv, comparator);
                    matches = this.matches(op, compareResult);
                }
            }
        }
        return matches;
    }

    private void checkFamily(Region region, byte[] family) throws NoSuchColumnFamilyException {
        if (!region.getTableDescriptor().hasColumnFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString(family) + " does not exist in region " + this + " in table " + region.getTableDescriptor());
        }
    }

    private boolean matches(CompareOperator op, int compareResult) {
        switch (op) {
            case LESS: {
                return compareResult < 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult <= 0;
            }
            case EQUAL: {
                return compareResult == 0;
            }
            case NOT_EQUAL: {
                return compareResult != 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult >= 0;
            }
            case GREATER: {
                return compareResult > 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    @Override
    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

