/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ServiceNotRunningException;
import org.apache.hadoop.hbase.master.ClusterSchemaService;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ModifyNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.AbstractService;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ClusterSchemaServiceImpl
extends AbstractService
implements ClusterSchemaService {
    private final TableNamespaceManager tableNamespaceManager;
    private final MasterServices masterServices;

    ClusterSchemaServiceImpl(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.tableNamespaceManager = new TableNamespaceManager(masterServices);
    }

    private synchronized void checkIsRunning() throws ServiceNotRunningException {
        if (!this.isRunning()) {
            throw new ServiceNotRunningException();
        }
    }

    @Override
    protected synchronized void doStart() {
        try {
            this.notifyStarted();
            this.tableNamespaceManager.start();
        }
        catch (IOException ioe) {
            this.notifyFailed(ioe);
        }
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
    }

    @Override
    public TableNamespaceManager getTableNamespaceManager() {
        return this.tableNamespaceManager;
    }

    private long submitProcedure(Procedure<MasterProcedureEnv> procedure, NonceKey nonceKey) throws ServiceNotRunningException {
        this.checkIsRunning();
        ProcedureExecutor<MasterProcedureEnv> pe = this.masterServices.getMasterProcedureExecutor();
        return pe.submitProcedure(procedure, nonceKey);
    }

    @Override
    public long createNamespace(NamespaceDescriptor namespaceDescriptor, NonceKey nonceKey, ProcedurePrepareLatch latch) throws IOException {
        return this.submitProcedure(new CreateNamespaceProcedure(this.masterServices.getMasterProcedureExecutor().getEnvironment(), namespaceDescriptor, latch), nonceKey);
    }

    @Override
    public long modifyNamespace(NamespaceDescriptor namespaceDescriptor, NonceKey nonceKey, ProcedurePrepareLatch latch) throws IOException {
        return this.submitProcedure(new ModifyNamespaceProcedure(this.masterServices.getMasterProcedureExecutor().getEnvironment(), namespaceDescriptor, latch), nonceKey);
    }

    @Override
    public long deleteNamespace(String name, NonceKey nonceKey, ProcedurePrepareLatch latch) throws IOException {
        return this.submitProcedure(new DeleteNamespaceProcedure(this.masterServices.getMasterProcedureExecutor().getEnvironment(), name, latch), nonceKey);
    }

    @Override
    public NamespaceDescriptor getNamespace(String name) throws IOException {
        NamespaceDescriptor nsd = this.getTableNamespaceManager().get(name);
        if (nsd == null) {
            throw new NamespaceNotFoundException(name);
        }
        return nsd;
    }

    @Override
    public List<NamespaceDescriptor> getNamespaces() throws IOException {
        this.checkIsRunning();
        return this.getTableNamespaceManager().list().stream().sorted(NamespaceDescriptor.NAMESPACE_DESCRIPTOR_COMPARATOR).collect(ImmutableList.toImmutableList());
    }
}

