/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.shaded.org.agrona.collections.Int2IntCounterMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class RegionReplicaGroupingCostFunction
extends CostFunction {
    protected long maxCost = 0L;
    protected long[] costsPerGroup;

    RegionReplicaGroupingCostFunction() {
    }

    @Override
    final void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        if (!this.isNeeded()) {
            return;
        }
        this.loadCosts();
    }

    protected abstract void loadCosts();

    protected final long getMaxCost(BalancerClusterState cluster) {
        Int2IntCounterMap colocatedReplicaCounts = new Int2IntCounterMap(cluster.numRegions, 0.65f, 0);
        for (int i = 0; i < cluster.regionIndexToPrimaryIndex.length; ++i) {
            colocatedReplicaCounts.getAndIncrement(cluster.regionIndexToPrimaryIndex[i]);
        }
        return this.costPerGroup(colocatedReplicaCounts);
    }

    @Override
    boolean isNeeded() {
        return this.cluster.hasRegionReplicas;
    }

    @Override
    protected double cost() {
        if (this.maxCost <= 0L) {
            return 0.0;
        }
        long totalCost = 0L;
        for (int i = 0; i < this.costsPerGroup.length; ++i) {
            totalCost += this.costsPerGroup[i];
        }
        return RegionReplicaGroupingCostFunction.scale(0.0, this.maxCost, totalCost);
    }

    @Override
    public final void updateWeight(double[] weights) {
        int n = StochasticLoadBalancer.GeneratorType.RACK.ordinal();
        weights[n] = weights[n] + this.cost();
    }

    protected final long costPerGroup(Int2IntCounterMap colocatedReplicaCounts) {
        AtomicLong cost = new AtomicLong(0L);
        colocatedReplicaCounts.forEach((primary, count) -> {
            if (count > 1) {
                cost.getAndAdd((count - 1) * (count - 1));
            }
        });
        return cost.longValue();
    }
}

