/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.regionserver.SnapshotRegionCallable;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotRegionProcedure
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotRegionProcedure.class);
    private SnapshotProtos.SnapshotDescription snapshot;
    private ProcedureEvent<?> event;
    private RegionInfo region;
    private boolean dispatched;
    private boolean succ;
    private RetryCounter retryCounter;

    public SnapshotRegionProcedure() {
    }

    public SnapshotRegionProcedure(SnapshotProtos.SnapshotDescription snapshot, RegionInfo region) {
        this.snapshot = snapshot;
        this.region = region;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitRegions(this, this.getTableName(), this.region)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegions(this, this.getTableName(), this.region);
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return false;
    }

    @Override
    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), SnapshotRegionCallable.class, MasterProcedureProtos.SnapshotRegionParameter.newBuilder().setRegion(ProtobufUtil.toRegionInfo(this.region)).setSnapshot(this.snapshot).build().toByteArray()));
    }

    @Override
    public void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException e) {
        this.complete(env, e);
    }

    @Override
    public void remoteOperationCompleted(MasterProcedureEnv env) {
        this.complete(env, null);
    }

    @Override
    public void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException e) {
        this.complete(env, e);
    }

    private void complete(MasterProcedureEnv env, Throwable error) {
        if (this.isFinished()) {
            LOG.info("This procedure {} is already finished, skip the rest processes", (Object)this.getProcId());
            return;
        }
        if (this.event == null) {
            LOG.warn("procedure event for {} is null, maybe the procedure is created when recovery", (Object)this.getProcId());
            return;
        }
        if (error == null) {
            LOG.info("finish snapshot {} on region {}", (Object)this.snapshot.getName(), (Object)this.region.getEncodedName());
            this.succ = true;
        }
        this.event.wake(env.getProcedureScheduler());
        this.event = null;
    }

    @Override
    public TableName getTableName() {
        return this.region.getTable();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_SNAPSHOT;
    }

    @Override
    protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        if (this.dispatched) {
            if (this.succ) {
                return null;
            }
            this.dispatched = false;
        }
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        RegionStateNode regionNode = regionStates.getRegionStateNode(this.region);
        regionNode.lock();
        try {
            if (regionNode.getProcedure() != null) {
                this.setTimeoutForSuspend(env, String.format("region %s has a TRSP attached %s", this.region.getRegionNameAsString(), regionNode.getProcedure()));
                throw new ProcedureSuspendedException();
            }
            if (!regionNode.isInState(RegionState.State.OPEN)) {
                this.setTimeoutForSuspend(env, String.format("region state of %s is %s", new Object[]{this.region.getRegionNameAsString(), regionNode.getState()}));
                throw new ProcedureSuspendedException();
            }
            ServerName targetServer = regionNode.getRegionLocation();
            if (targetServer == null) {
                this.setTimeoutForSuspend(env, String.format("target server of region %s is null", this.region.getRegionNameAsString()));
                throw new ProcedureSuspendedException();
            }
            ServerState serverState = regionStates.getServerNode(targetServer).getState();
            if (serverState != ServerState.ONLINE) {
                this.setTimeoutForSuspend(env, String.format("target server of region %s %s is in state %s", new Object[]{this.region.getRegionNameAsString(), targetServer, serverState}));
                throw new ProcedureSuspendedException();
            }
            try {
                env.getRemoteDispatcher().addOperationToNode(targetServer, this);
                this.dispatched = true;
                this.event = new ProcedureEvent<SnapshotRegionProcedure>(this);
                this.event.suspendIfNotReady(this);
                throw new ProcedureSuspendedException();
            }
            catch (FailedRemoteDispatchException e) {
                this.setTimeoutForSuspend(env, "Failed send request to " + targetServer);
                throw new ProcedureSuspendedException();
            }
        }
        catch (Throwable throwable) {
            regionNode.unlock();
            throw throwable;
        }
    }

    @Override
    protected void rollback(MasterProcedureEnv env) {
        throw new UnsupportedOperationException();
    }

    private void setTimeoutForSuspend(MasterProcedureEnv env, String reason) {
        if (this.retryCounter == null) {
            this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
        }
        long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
        LOG.warn("{} can not run currently because {}, wait {} ms to retry", new Object[]{this, reason, backoff});
        this.setTimeout(Math.toIntExact(backoff));
        this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.skipPersistence();
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SnapshotRegionProcedureStateData.Builder builder = MasterProcedureProtos.SnapshotRegionProcedureStateData.newBuilder();
        builder.setSnapshot(this.snapshot);
        builder.setRegion(ProtobufUtil.toRegionInfo(this.region));
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SnapshotRegionProcedureStateData data = serializer.deserialize(MasterProcedureProtos.SnapshotRegionProcedureStateData.class);
        this.snapshot = data.getSnapshot();
        this.region = ProtobufUtil.toRegionInfo(data.getRegion());
    }

    @Override
    public String getProcName() {
        return this.getClass().getSimpleName() + " " + this.region.getEncodedName();
    }

    @Override
    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getProcName());
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    public RegionInfo getRegion() {
        return this.region;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|TestSnapshotProcedure).java")
    boolean inRetrying() {
        return this.retryCounter != null;
    }
}

