/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.replication.AbstractPeerNoLockProcedure;
import org.apache.hadoop.hbase.master.replication.RefreshPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.replication.ReplicationBarrierFamilyFormat;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractPeerProcedure<TState>
extends AbstractPeerNoLockProcedure<TState>
implements PeerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPeerProcedure.class);
    protected static final int UPDATE_LAST_SEQ_ID_BATCH_SIZE = 1000;
    protected static final int SLEEP_INTERVAL_MS = 1000;
    protected ProcedurePrepareLatch latch;

    protected AbstractPeerProcedure() {
    }

    protected AbstractPeerProcedure(String peerId) {
        super(peerId);
        this.latch = ProcedurePrepareLatch.createLatch(2, 1);
    }

    public ProcedurePrepareLatch getLatch() {
        return this.latch;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitPeerExclusiveLock(this, this.peerId)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakePeerExclusiveLock(this, this.peerId);
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected final void refreshPeer(MasterProcedureEnv env, PeerProcedureInterface.PeerOperationType type) {
        this.addChildProcedure((Procedure[])env.getMasterServices().getServerManager().getOnlineServersList().stream().map(sn -> new RefreshPeerProcedure(this.peerId, type, (ServerName)sn)).toArray(RefreshPeerProcedure[]::new));
    }

    protected void enablePeer(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().enablePeer(this.peerId);
    }

    private void addToMap(Map<String, Long> lastSeqIds, String encodedRegionName, long barrier, ReplicationQueueStorage queueStorage) throws ReplicationException {
        if (barrier >= 0L) {
            lastSeqIds.put(encodedRegionName, barrier);
            if (lastSeqIds.size() >= 1000) {
                queueStorage.setLastSequenceIds(this.peerId, lastSeqIds);
                lastSeqIds.clear();
            }
        }
    }

    protected final void setLastPushedSequenceId(MasterProcedureEnv env, ReplicationPeerConfig peerConfig) throws IOException, ReplicationException {
        HashMap<String, Long> lastSeqIds = new HashMap<String, Long>();
        for (TableDescriptor td : env.getMasterServices().getTableDescriptors().getAll().values()) {
            TableName tn;
            if (!td.hasGlobalReplicationScope() || !peerConfig.needToReplicate(tn = td.getTableName())) continue;
            this.setLastPushedSequenceIdForTable(env, tn, lastSeqIds);
        }
        if (!lastSeqIds.isEmpty()) {
            env.getReplicationPeerManager().getQueueStorage().setLastSequenceIds(this.peerId, lastSeqIds);
        }
    }

    private boolean needSetLastPushedSequenceId(TableStateManager tsm, TableName tn) throws IOException {
        try {
            while (true) {
                if (!tsm.getTableState(tn).isDisabling()) {
                    return true;
                }
                Thread.sleep(1000L);
            }
        }
        catch (TableNotFoundException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    protected final void setLastPushedSequenceIdForTable(MasterProcedureEnv env, TableName tableName, Map<String, Long> lastSeqIds) throws IOException, ReplicationException {
        TableStateManager tsm = env.getMasterServices().getTableStateManager();
        ReplicationQueueStorage queueStorage = env.getReplicationPeerManager().getQueueStorage();
        Connection conn = env.getMasterServices().getConnection();
        if (!this.needSetLastPushedSequenceId(tsm, tableName)) {
            LOG.debug("Skip settting last pushed sequence id for {}", (Object)tableName);
            return;
        }
        for (Pair<String, Long> name2Barrier : ReplicationBarrierFamilyFormat.getTableEncodedRegionNameAndLastBarrier(conn, tableName)) {
            LOG.trace("Update last pushed sequence id for {}, {}", (Object)tableName, name2Barrier);
            this.addToMap(lastSeqIds, name2Barrier.getFirst(), name2Barrier.getSecond() - 1L, queueStorage);
        }
    }

    protected final void checkPeerModificationEnabled(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().isReplicationPeerModificationEnabled()) {
            throw new IOException("Replication peer modification disabled");
        }
    }
}

