/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ProcedureFutureUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureFutureUtil.class);

    private ProcedureFutureUtil() {
    }

    public static boolean checkFuture(Procedure<?> proc, Supplier<CompletableFuture<Void>> getFuture, Consumer<CompletableFuture<Void>> setFuture, Runnable actionAfterDone) throws IOException {
        CompletableFuture<Void> future = getFuture.get();
        if (future == null) {
            return false;
        }
        setFuture.accept(null);
        FutureUtils.get(future);
        actionAfterDone.run();
        return true;
    }

    public static void suspendIfNecessary(Procedure<?> proc, Consumer<CompletableFuture<Void>> setFuture, CompletableFuture<Void> future, MasterProcedureEnv env, Runnable actionAfterDone) throws IOException, ProcedureSuspendedException {
        MutableBoolean completed = new MutableBoolean(false);
        Thread currentThread = Thread.currentThread();
        ExecutorService asyncTaskExecutor = env.getAsyncTaskExecutor();
        FutureUtils.addListener(future, (r, e) -> {
            if (Thread.currentThread() == currentThread) {
                LOG.debug("The future has completed while adding callback, give up suspending procedure {}", (Object)proc);
                completed.setTrue();
                return;
            }
            LOG.debug("Going to wake up procedure {} because future has completed", (Object)proc);
            asyncTaskExecutor.execute(() -> ProcedureFutureUtil.wakeUp(proc, env));
        });
        if (completed.getValue().booleanValue()) {
            FutureUtils.get(future);
            actionAfterDone.run();
        } else {
            setFuture.accept(future);
            proc.skipPersistence();
            ProcedureFutureUtil.suspend(proc);
        }
    }

    public static void suspend(Procedure<?> proc) throws ProcedureSuspendedException {
        proc.skipPersistence();
        throw new ProcedureSuspendedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wakeUp(Procedure<?> proc, MasterProcedureEnv env) {
        IdLock.Entry lockEntry;
        IdLock procLock = env.getMasterServices().getMasterProcedureExecutor().getProcExecutionLock();
        try {
            lockEntry = procLock.getLockEntry(proc.getProcId());
        }
        catch (IOException e) {
            LOG.error("Error while acquiring execution lock for procedure {} when trying to wake it up, aborting...", proc, (Object)e);
            env.getMasterServices().abort("Can not acquire procedure execution lock", e);
            return;
        }
        try {
            env.getProcedureScheduler().addFront(proc);
        }
        finally {
            procLock.releaseLockEntry(lockEntry);
        }
    }
}

