/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.BloomFilterMetrics;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.InputStreamBlockDistribution;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HStoreFile
implements StoreFile {
    private static final Logger LOG = LoggerFactory.getLogger((String)HStoreFile.class.getName());
    public static final byte[] MAX_SEQ_ID_KEY = Bytes.toBytes("MAX_SEQ_ID_KEY");
    public static final byte[] MAJOR_COMPACTION_KEY = Bytes.toBytes("MAJOR_COMPACTION_KEY");
    public static final byte[] EXCLUDE_FROM_MINOR_COMPACTION_KEY = Bytes.toBytes("EXCLUDE_FROM_MINOR_COMPACTION");
    public static final byte[] COMPACTION_EVENT_KEY = Bytes.toBytes("COMPACTION_EVENT_KEY");
    public static final byte[] BLOOM_FILTER_TYPE_KEY = Bytes.toBytes("BLOOM_FILTER_TYPE");
    public static final byte[] BLOOM_FILTER_PARAM_KEY = Bytes.toBytes("BLOOM_FILTER_PARAM");
    public static final byte[] DELETE_FAMILY_COUNT = Bytes.toBytes("DELETE_FAMILY_COUNT");
    public static final byte[] LAST_BLOOM_KEY = Bytes.toBytes("LAST_BLOOM_KEY");
    public static final byte[] TIMERANGE_KEY = Bytes.toBytes("TIMERANGE");
    public static final byte[] EARLIEST_PUT_TS = Bytes.toBytes("EARLIEST_PUT_TS");
    public static final byte[] MOB_CELLS_COUNT = Bytes.toBytes("MOB_CELLS_COUNT");
    public static final byte[] NULL_VALUE = new byte[]{0};
    public static final byte[] MOB_FILE_REFS = Bytes.toBytes("MOB_FILE_REFS");
    public static final byte[] BULKLOAD_TASK_KEY = Bytes.toBytes("BULKLOAD_SOURCE_TASK");
    public static final byte[] BULKLOAD_TIME_KEY = Bytes.toBytes("BULKLOAD_TIMESTAMP");
    public static final byte[] SKIP_RESET_SEQ_ID = Bytes.toBytes("SKIP_RESET_SEQ_ID");
    private final StoreFileInfo fileInfo;
    private volatile StoreFileReader initialReader;
    private volatile InputStreamBlockDistribution initialReaderBlockDistribution = null;
    private final CacheConfig cacheConf;
    private final BloomFilterMetrics metrics;
    private volatile boolean compactedAway = false;
    private long sequenceid = -1L;
    private long maxMemstoreTS = -1L;
    private Optional<Cell> firstKey;
    private Optional<Cell> lastKey;
    private CellComparator comparator;
    private AtomicBoolean majorCompaction = null;
    private boolean excludeFromMinorCompaction = false;
    private final Set<String> compactedStoreFiles = new HashSet<String>();
    private Map<byte[], byte[]> metadataMap;
    private final BloomType cfBloomType;

    public CacheConfig getCacheConf() {
        return this.cacheConf;
    }

    @Override
    public Optional<Cell> getFirstKey() {
        return this.firstKey;
    }

    @Override
    public Optional<Cell> getLastKey() {
        return this.lastKey;
    }

    @Override
    public CellComparator getComparator() {
        return this.comparator;
    }

    @Override
    public long getMaxMemStoreTS() {
        return this.maxMemstoreTS;
    }

    public HStoreFile(FileSystem fs, Path p, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType, boolean primaryReplica) throws IOException {
        this(new StoreFileInfo(conf, fs, p, primaryReplica), cfBloomType, cacheConf);
    }

    public HStoreFile(StoreFileInfo fileInfo, BloomType cfBloomType, CacheConfig cacheConf) {
        this(fileInfo, cfBloomType, cacheConf, null);
    }

    public HStoreFile(StoreFileInfo fileInfo, BloomType cfBloomType, CacheConfig cacheConf, BloomFilterMetrics metrics) {
        this.fileInfo = fileInfo;
        this.cacheConf = cacheConf;
        this.metrics = metrics;
        if (BloomFilterFactory.isGeneralBloomEnabled(fileInfo.getConf())) {
            this.cfBloomType = cfBloomType;
        } else {
            LOG.info("Ignoring bloom filter check for file " + this.getPath() + ": cfBloomType=" + (Object)((Object)cfBloomType) + " (disabled in config)");
            this.cfBloomType = BloomType.NONE;
        }
    }

    public StoreFileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public Path getPath() {
        return this.fileInfo.getPath();
    }

    @Override
    public Path getEncodedPath() {
        try {
            return new Path(URLEncoder.encode(this.fileInfo.getPath().toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("URLEncoder doesn't support UTF-8", ex);
        }
    }

    @Override
    public Path getQualifiedPath() {
        FileSystem fs = this.fileInfo.getFileSystem();
        return this.fileInfo.getPath().makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    @Override
    public boolean isReference() {
        return this.fileInfo.isReference();
    }

    @Override
    public boolean isHFile() {
        return StoreFileInfo.isHFile(this.fileInfo.getPath());
    }

    @Override
    public boolean isMajorCompactionResult() {
        Preconditions.checkState(this.majorCompaction != null, "Major compation has not been set yet");
        return this.majorCompaction.get();
    }

    @Override
    public boolean excludeFromMinorCompaction() {
        return this.excludeFromMinorCompaction;
    }

    @Override
    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    @Override
    public long getModificationTimestamp() throws IOException {
        return this.fileInfo.getModificationTime();
    }

    public byte[] getMetadataValue(byte[] key) {
        return this.metadataMap.get(key);
    }

    @Override
    public boolean isBulkLoadResult() {
        boolean bulkLoadedHFile = false;
        String fileName = this.getPath().getName();
        int startPos = fileName.indexOf("SeqId_");
        if (startPos != -1) {
            bulkLoadedHFile = true;
        }
        return bulkLoadedHFile || this.metadataMap != null && this.metadataMap.containsKey(BULKLOAD_TIME_KEY);
    }

    public boolean isCompactedAway() {
        return this.compactedAway;
    }

    public int getRefCount() {
        return this.fileInfo.getRefCount();
    }

    public boolean isReferencedInReads() {
        int rc = this.fileInfo.getRefCount();
        assert (rc >= 0);
        return rc > 0;
    }

    @Override
    public OptionalLong getBulkLoadTimestamp() {
        byte[] bulkLoadTimestamp = this.metadataMap.get(BULKLOAD_TIME_KEY);
        return bulkLoadTimestamp == null ? OptionalLong.empty() : OptionalLong.of(Bytes.toLong(bulkLoadTimestamp));
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        if (this.initialReaderBlockDistribution != null) {
            return this.initialReaderBlockDistribution.getHDFSBlockDistribution();
        }
        return this.fileInfo.getHDFSBlockDistribution();
    }

    private void open() throws IOException {
        byte[] data;
        this.fileInfo.initHDFSBlocksDistribution();
        long readahead = this.fileInfo.isNoReadahead() ? 0L : -1L;
        ReaderContext context = this.fileInfo.createReaderContext(false, readahead, ReaderContext.ReaderType.PREAD);
        this.fileInfo.initHFileInfo(context);
        StoreFileReader reader = this.fileInfo.preStoreFileReaderOpen(context, this.cacheConf);
        if (reader == null) {
            reader = this.fileInfo.createReader(context, this.cacheConf);
            this.fileInfo.getHFileInfo().initMetaAndIndex(reader.getHFileReader());
        }
        this.initialReader = this.fileInfo.postStoreFileReaderOpen(context, this.cacheConf, reader);
        if (InputStreamBlockDistribution.isEnabled(this.fileInfo.getConf())) {
            boolean useHBaseChecksum = context.getInputStreamWrapper().shouldUseHBaseChecksum();
            FSDataInputStream stream = context.getInputStreamWrapper().getStream(useHBaseChecksum);
            this.initialReaderBlockDistribution = new InputStreamBlockDistribution(stream, this.fileInfo);
        }
        this.metadataMap = Collections.unmodifiableMap(this.initialReader.loadFileInfo());
        byte[] b = this.metadataMap.get(MAX_SEQ_ID_KEY);
        if (b != null) {
            this.sequenceid = Bytes.toLong(b);
            if (this.fileInfo.isTopReference()) {
                ++this.sequenceid;
            }
        }
        if (this.isBulkLoadResult()) {
            boolean skipResetSeqId;
            String fileName = this.getPath().getName();
            int startPos = fileName.lastIndexOf("SeqId_");
            if (startPos != -1) {
                this.sequenceid = Long.parseLong(fileName.substring(startPos + 6, fileName.indexOf(95, startPos + 6)));
                if (this.fileInfo.isTopReference()) {
                    ++this.sequenceid;
                }
            }
            if (skipResetSeqId = this.isSkipResetSeqId(this.metadataMap.get(SKIP_RESET_SEQ_ID))) {
                ++this.sequenceid;
            }
            this.initialReader.setSkipResetSeqId(skipResetSeqId);
            this.initialReader.setBulkLoaded(true);
        }
        this.initialReader.setSequenceID(this.sequenceid);
        b = this.metadataMap.get(HFile.Writer.MAX_MEMSTORE_TS_KEY);
        if (b != null) {
            this.maxMemstoreTS = Bytes.toLong(b);
        }
        if ((b = this.metadataMap.get(MAJOR_COMPACTION_KEY)) != null) {
            boolean mc = Bytes.toBoolean(b);
            if (this.majorCompaction == null) {
                this.majorCompaction = new AtomicBoolean(mc);
            } else {
                this.majorCompaction.set(mc);
            }
        } else {
            this.majorCompaction = new AtomicBoolean(false);
        }
        b = this.metadataMap.get(EXCLUDE_FROM_MINOR_COMPACTION_KEY);
        this.excludeFromMinorCompaction = b != null && Bytes.toBoolean(b);
        BloomType hfileBloomType = this.initialReader.getBloomFilterType();
        if (this.cfBloomType != BloomType.NONE) {
            this.initialReader.loadBloomfilter(BlockType.GENERAL_BLOOM_META, this.metrics);
            if (hfileBloomType != this.cfBloomType) {
                LOG.debug("HFile Bloom filter type for " + this.initialReader.getHFileReader().getName() + ": " + (Object)((Object)hfileBloomType) + ", but " + (Object)((Object)this.cfBloomType) + " specified in column family configuration");
            }
        } else if (hfileBloomType != BloomType.NONE) {
            LOG.info("Bloom filter turned off by CF config for " + this.initialReader.getHFileReader().getName());
        }
        this.initialReader.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META, this.metrics);
        try {
            data = this.metadataMap.get(TIMERANGE_KEY);
            this.initialReader.timeRange = data == null ? null : TimeRangeTracker.parseFrom(data).toTimeRange();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error reading timestamp range data from meta -- proceeding without", (Throwable)e);
            this.initialReader.timeRange = null;
        }
        try {
            data = this.metadataMap.get(COMPACTION_EVENT_KEY);
            this.compactedStoreFiles.addAll(ProtobufUtil.toCompactedStoreFiles(data));
        }
        catch (IOException e) {
            LOG.error("Error reading compacted storefiles from meta data", (Throwable)e);
        }
        this.firstKey = this.initialReader.getFirstKey();
        this.lastKey = this.initialReader.getLastKey();
        this.comparator = this.initialReader.getComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initReader() throws IOException {
        if (this.initialReader == null) {
            HStoreFile hStoreFile = this;
            synchronized (hStoreFile) {
                if (this.initialReader == null) {
                    try {
                        this.open();
                    }
                    catch (Exception e) {
                        try {
                            boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
                            this.closeStoreFile(evictOnClose);
                        }
                        catch (IOException ee) {
                            LOG.warn("failed to close reader", (Throwable)ee);
                        }
                        throw e;
                    }
                }
            }
        }
    }

    private StoreFileReader createStreamReader(boolean canUseDropBehind) throws IOException {
        this.initReader();
        boolean doDropBehind = canUseDropBehind && this.cacheConf.shouldDropBehindCompaction();
        ReaderContext context = this.fileInfo.createReaderContext(doDropBehind, -1L, ReaderContext.ReaderType.STREAM);
        StoreFileReader reader = this.fileInfo.preStoreFileReaderOpen(context, this.cacheConf);
        if (reader == null) {
            reader = this.fileInfo.createReader(context, this.cacheConf);
            reader.copyFields(this.initialReader);
        }
        return this.fileInfo.postStoreFileReaderOpen(context, this.cacheConf, reader);
    }

    public StoreFileScanner getPreadScanner(boolean cacheBlocks, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        return this.getReader().getStoreFileScanner(cacheBlocks, true, false, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public StoreFileScanner getStreamScanner(boolean canUseDropBehind, boolean cacheBlocks, boolean isCompaction, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) throws IOException {
        return this.createStreamReader(canUseDropBehind).getStoreFileScanner(cacheBlocks, false, isCompaction, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public StoreFileReader getReader() {
        return this.initialReader;
    }

    public synchronized void closeStoreFile(boolean evictOnClose) throws IOException {
        if (this.initialReader != null) {
            this.initialReader.close(evictOnClose);
            this.initialReader = null;
        }
    }

    public void deleteStoreFile() throws IOException {
        boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
        this.closeStoreFile(evictOnClose);
        this.fileInfo.getFileSystem().delete(this.getPath(), true);
    }

    public void markCompactedAway() {
        this.compactedAway = true;
    }

    public String toString() {
        return this.fileInfo.toString();
    }

    @Override
    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath().toString());
        sb.append(", isReference=").append(this.isReference());
        sb.append(", isBulkLoadResult=").append(this.isBulkLoadResult());
        if (this.isBulkLoadResult()) {
            sb.append(", bulkLoadTS=");
            OptionalLong bulkLoadTS = this.getBulkLoadTimestamp();
            if (bulkLoadTS.isPresent()) {
                sb.append(bulkLoadTS.getAsLong());
            } else {
                sb.append("NotPresent");
            }
        } else {
            sb.append(", seqid=").append(this.getMaxSequenceId());
        }
        sb.append(", majorCompaction=").append(this.isMajorCompactionResult());
        return sb.toString();
    }

    private boolean isSkipResetSeqId(byte[] skipResetSeqId) {
        if (skipResetSeqId != null && skipResetSeqId.length == 1) {
            return Bytes.toBoolean(skipResetSeqId);
        }
        return false;
    }

    @Override
    public OptionalLong getMinimumTimestamp() {
        TimeRange tr = this.getReader().timeRange;
        return tr != null ? OptionalLong.of(tr.getMin()) : OptionalLong.empty();
    }

    @Override
    public OptionalLong getMaximumTimestamp() {
        TimeRange tr = this.getReader().timeRange;
        return tr != null ? OptionalLong.of(tr.getMax()) : OptionalLong.empty();
    }

    Set<String> getCompactedStoreFiles() {
        return Collections.unmodifiableSet(this.compactedStoreFiles);
    }

    long increaseRefCount() {
        return this.fileInfo.increaseRefCount();
    }

    long decreaseRefCount() {
        return this.fileInfo.decreaseRefCount();
    }

    static void increaseStoreFilesRefeCount(Collection<HStoreFile> storeFiles) {
        if (CollectionUtils.isEmpty(storeFiles)) {
            return;
        }
        storeFiles.forEach(HStoreFile::increaseRefCount);
    }

    static void decreaseStoreFilesRefeCount(Collection<HStoreFile> storeFiles) {
        if (CollectionUtils.isEmpty(storeFiles)) {
            return;
        }
        storeFiles.forEach(HStoreFile::decreaseRefCount);
    }
}

