/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsTable {
    private final MetricsTableAggregateSource tableSourceAgg = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).getTableAggregate();
    private MetricsTableWrapperAggregate wrapper;

    public MetricsTable(MetricsTableWrapperAggregate wrapper) {
        this.wrapper = wrapper;
    }

    public MetricsTableWrapperAggregate getTableWrapperAgg() {
        return this.wrapper;
    }

    public MetricsTableAggregateSource getTableSourceAgg() {
        return this.tableSourceAgg;
    }

    public void incrSplitRequest(String table) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).incrSplitRequest();
    }

    public void incrSplitSuccess(String table) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).incrSplitSuccess();
    }

    public void updateSplitTime(String table, long t) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateSplitTime(t);
    }

    public void updateFlushTime(String table, long t) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateFlushTime(t);
    }

    public void updateFlushMemstoreSize(String table, long bytes) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateFlushMemstoreSize(bytes);
    }

    public void updateFlushOutputSize(String table, long bytes) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateFlushOutputSize(bytes);
    }

    public void updateCompactionTime(String table, boolean isMajor, long t) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateCompactionTime(isMajor, t);
    }

    public void updateCompactionInputFileCount(String table, boolean isMajor, long c) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateCompactionInputFileCount(isMajor, c);
    }

    public void updateCompactionInputSize(String table, boolean isMajor, long bytes) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateCompactionInputSize(isMajor, bytes);
    }

    public void updateCompactionOutputFileCount(String table, boolean isMajor, long c) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateCompactionOutputFileCount(isMajor, c);
    }

    public void updateCompactionOutputSize(String table, boolean isMajor, long bytes) {
        this.tableSourceAgg.getOrCreateTableSource(table, this.wrapper).updateCompactionOutputSize(isMajor, bytes);
    }
}

